/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.subscription;

import com.github.msemys.esjc.ResolvedEvent;
import com.github.msemys.esjc.Subscription;
import com.github.msemys.esjc.SubscriptionListener;
import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.operation.InspectionDecision;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.subscription.AbstractSubscriptionOperation;
import com.github.msemys.esjc.subscription.VolatileSubscription;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.tcp.TcpPackage;
import com.google.protobuf.MessageLite;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class VolatileSubscriptionOperation
extends AbstractSubscriptionOperation<VolatileSubscription, ResolvedEvent> {
    public VolatileSubscriptionOperation(CompletableFuture<Subscription> result, String streamId, boolean resolveLinkTos, UserCredentials userCredentials, SubscriptionListener listener, Supplier<Channel> connectionSupplier, Executor executor) {
        super(result, TcpCommand.SubscribeToStream, streamId, resolveLinkTos, userCredentials, listener, connectionSupplier, executor);
    }

    @Override
    protected MessageLite createSubscribeMessage() {
        return EventStoreClientMessages.SubscribeToStream.newBuilder().setEventStreamId(this.streamId).setResolveLinkTos(this.resolveLinkTos).build();
    }

    @Override
    protected VolatileSubscription createSubscription(long lastCommitPosition, Long lastEventNumber) {
        return new VolatileSubscription(this, this.streamId, lastCommitPosition, lastEventNumber);
    }

    @Override
    protected boolean inspect(TcpPackage tcpPackage, InspectionResult.Builder builder) {
        switch (tcpPackage.command) {
            case SubscriptionConfirmation: {
                EventStoreClientMessages.SubscriptionConfirmation confirmation = VolatileSubscriptionOperation.newInstance(EventStoreClientMessages.SubscriptionConfirmation.getDefaultInstance(), tcpPackage.data);
                this.confirmSubscription(confirmation.getLastCommitPosition(), confirmation.hasLastEventNumber() ? Long.valueOf(confirmation.getLastEventNumber()) : null);
                builder.decision(InspectionDecision.Subscribed).description("SubscriptionConfirmation");
                return true;
            }
            case StreamEventAppeared: {
                EventStoreClientMessages.StreamEventAppeared streamEventAppeared = VolatileSubscriptionOperation.newInstance(EventStoreClientMessages.StreamEventAppeared.getDefaultInstance(), tcpPackage.data);
                this.eventAppeared(new ResolvedEvent(streamEventAppeared.getEvent()));
                builder.decision(InspectionDecision.DoNothing).description("StreamEventAppeared");
                return true;
            }
        }
        return false;
    }
}

