/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.subscription.manager;

import com.github.msemys.esjc.subscription.SubscriptionOperation;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.SystemTime;
import io.netty.channel.ChannelId;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;

public class SubscriptionItem {
    public final SubscriptionOperation operation;
    public final int maxRetries;
    public final Duration timeout;
    public final Instant createdTime;
    public ChannelId connectionId;
    public UUID correlationId;
    public boolean isSubscribed;
    public int retryCount;
    public final SystemTime lastUpdated;

    public SubscriptionItem(SubscriptionOperation operation, int maxRetries, Duration timeout) {
        Preconditions.checkNotNull(operation, "operation is null");
        this.operation = operation;
        this.maxRetries = maxRetries;
        this.timeout = timeout;
        this.createdTime = Instant.now();
        this.correlationId = UUID.randomUUID();
        this.retryCount = 0;
        this.lastUpdated = SystemTime.now();
    }

    public String toString() {
        return "Subscription " + this.operation.getClass().getSimpleName() + " (" + this.correlationId + "): " + this.operation + ", is subscribed: " + this.isSubscribed + ", retry count: " + this.retryCount + ", created: " + this.createdTime + ", last updated: " + this.lastUpdated;
    }
}

