/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.system;

import com.github.msemys.esjc.util.Preconditions;

public class SystemStreams {
    public static final String SETTINGS_STREAM = "$settings";
    public static final String STATS_STREAM_PREFIX = "$stats";
    public static final String METASTREAM_PREFIX = "$$";

    private SystemStreams() {
    }

    public static String metastreamOf(String streamId) {
        return METASTREAM_PREFIX + streamId;
    }

    public static boolean isMetastream(String streamId) {
        return streamId.startsWith(METASTREAM_PREFIX);
    }

    public static String originalStreamOf(String metastreamId) {
        Preconditions.checkArgument(SystemStreams.isMetastream(metastreamId), "'%s' is not metastream", metastreamId);
        return metastreamId.substring(METASTREAM_PREFIX.length());
    }
}

