/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.task;

import com.github.msemys.esjc.task.Task;
import com.github.msemys.esjc.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class TaskQueue {
    private final Executor executor;
    private final Queue<Task> queue = new ConcurrentLinkedQueue<Task>();
    private final Map<Class<? extends Task>, Consumer<Task>> handlers = new HashMap<Class<? extends Task>, Consumer<Task>>();
    private final AtomicBoolean processing = new AtomicBoolean();

    public TaskQueue(Executor executor) {
        this.executor = executor;
    }

    public <T extends Task> void register(Class<T> type, Consumer<T> handler) {
        Preconditions.checkNotNull(type, "type is null");
        Preconditions.checkNotNull(handler, "handler is null");
        this.handlers.put(type, handler);
    }

    public void enqueue(Task task) {
        Preconditions.checkNotNull(task, "task is null");
        this.queue.offer(task);
        if (this.processing.compareAndSet(false, true)) {
            this.executor.execute(this::process);
        }
    }

    private void process() {
        while (true) {
            Task task;
            if ((task = this.queue.poll()) != null) {
                Consumer<Task> handler = this.handlers.get(task.getClass());
                Preconditions.checkState(handler != null, "No handler registered for task '%s'", task.getClass().getSimpleName());
                handler.accept(task);
                continue;
            }
            this.processing.set(false);
            if (this.queue.isEmpty() || !this.processing.compareAndSet(false, true)) break;
        }
    }
}

