/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.tcp;

public enum TcpCommand {
    HeartbeatRequestCommand(1),
    HeartbeatResponseCommand(2),
    Ping(3),
    Pong(4),
    PrepareAck(5),
    CommitAck(6),
    SlaveAssignment(7),
    CloneAssignment(8),
    SubscribeReplica(16),
    ReplicaLogPositionAck(17),
    CreateChunk(18),
    RawChunkBulk(19),
    DataChunkBulk(20),
    ReplicaSubscriptionRetry(21),
    ReplicaSubscribed(22),
    WriteEvents(130),
    WriteEventsCompleted(131),
    TransactionStart(132),
    TransactionStartCompleted(133),
    TransactionWrite(134),
    TransactionWriteCompleted(135),
    TransactionCommit(136),
    TransactionCommitCompleted(137),
    DeleteStream(138),
    DeleteStreamCompleted(139),
    ReadEvent(176),
    ReadEventCompleted(177),
    ReadStreamEventsForward(178),
    ReadStreamEventsForwardCompleted(179),
    ReadStreamEventsBackward(180),
    ReadStreamEventsBackwardCompleted(181),
    ReadAllEventsForward(182),
    ReadAllEventsForwardCompleted(183),
    ReadAllEventsBackward(184),
    ReadAllEventsBackwardCompleted(185),
    SubscribeToStream(192),
    SubscriptionConfirmation(193),
    StreamEventAppeared(194),
    UnsubscribeFromStream(195),
    SubscriptionDropped(196),
    ConnectToPersistentSubscription(197),
    PersistentSubscriptionConfirmation(198),
    PersistentSubscriptionStreamEventAppeared(199),
    CreatePersistentSubscription(200),
    CreatePersistentSubscriptionCompleted(201),
    DeletePersistentSubscription(202),
    DeletePersistentSubscriptionCompleted(203),
    PersistentSubscriptionAckEvents(204),
    PersistentSubscriptionNakEvents(205),
    UpdatePersistentSubscription(206),
    UpdatePersistentSubscriptionCompleted(207),
    ScavengeDatabase(208),
    ScavengeDatabaseCompleted(209),
    BadRequest(240),
    NotHandled(241),
    Authenticate(242),
    Authenticated(243),
    NotAuthenticated(244),
    IdentifyClient(245),
    ClientIdentified(246);

    public final byte value;

    private TcpCommand(int value) {
        this.value = (byte)value;
    }

    public static TcpCommand of(byte value) {
        for (TcpCommand c : TcpCommand.values()) {
            if (c.value != value) continue;
            return c;
        }
        throw new IllegalArgumentException(String.format("Unsupported TCP command %s", Integer.toHexString(value)));
    }
}

