/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.tcp;

import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.tcp.TcpFlag;
import com.github.msemys.esjc.util.EmptyArrays;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import com.github.msemys.esjc.util.UUIDConverter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;

public class TcpPackage {
    private static final int UUID_SIZE = 16;
    private static final int COMMAND_OFFSET = 0;
    private static final int FLAG_OFFSET = 1;
    private static final int CORRELATION_OFFSET = 2;
    private static final int AUTH_OFFSET = 18;
    private static final int MANDATORY_SIZE = 18;
    public final TcpCommand command;
    public final TcpFlag flag;
    public final UUID correlationId;
    public final String login;
    public final String password;
    public final byte[] data;

    private TcpPackage(Builder builder) {
        this.command = builder.command;
        this.flag = builder.flag;
        this.correlationId = builder.correlationId;
        this.login = builder.login;
        this.password = builder.password;
        this.data = builder.data;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public byte[] toByteArray() {
        byte[] result;
        if (this.flag == TcpFlag.Authenticated) {
            byte[] loginBytes = Strings.toBytes(this.login);
            byte[] passwordBytes = Strings.toBytes(this.password);
            Preconditions.checkArgument(loginBytes.length < 256, "Login serialized length should be less than 256 bytes (but is %d).", loginBytes.length);
            Preconditions.checkArgument(passwordBytes.length < 256, "Password serialized length should be less than 256 bytes (but is %d).", passwordBytes.length);
            result = this.createTcpPackage(20 + loginBytes.length + passwordBytes.length + this.data.length);
            result[18] = (byte)loginBytes.length;
            System.arraycopy(loginBytes, 0, result, 19, loginBytes.length);
            int passwordOffset = 19 + loginBytes.length;
            result[passwordOffset] = (byte)passwordBytes.length;
            System.arraycopy(passwordBytes, 0, result, passwordOffset + 1, passwordBytes.length);
        } else {
            result = this.createTcpPackage(18 + this.data.length);
        }
        System.arraycopy(this.data, 0, result, result.length - this.data.length, this.data.length);
        return result;
    }

    public static TcpPackage of(byte[] data) {
        Preconditions.checkArgument(data.length >= 18, "Data too short, length: %d", data.length);
        TcpCommand command = TcpCommand.of(data[0]);
        TcpFlag flag = TcpFlag.of(data[1]);
        UUID correlationId = UUIDConverter.toUUID(Arrays.copyOfRange(data, 2, 18));
        int headerSize = 18;
        String login = null;
        String password = null;
        if (flag == TcpFlag.Authenticated) {
            byte loginLength = data[18];
            Preconditions.checkState(19 + loginLength + 1 < data.length, "Login length is too big, it doesn't fit into TcpPackage.");
            login = new String(data, 19, (int)loginLength, StandardCharsets.UTF_8);
            int passwordOffset = 19 + loginLength;
            byte passwordLength = data[passwordOffset];
            Preconditions.checkState(passwordOffset + 1 + passwordLength <= data.length, "Password length is too big, it doesn't fit into TcpPackage.");
            password = new String(data, passwordOffset + 1, (int)passwordLength, StandardCharsets.UTF_8);
            headerSize += 1 + loginLength + 1 + passwordLength;
        }
        byte[] message = Arrays.copyOfRange(data, headerSize, data.length);
        return TcpPackage.newBuilder().command(command).flag(flag).correlationId(correlationId).login(login).password(password).data(message).build();
    }

    private byte[] createTcpPackage(int size) {
        byte[] result = new byte[size];
        result[0] = this.command.value;
        result[1] = this.flag.value;
        System.arraycopy(UUIDConverter.toBytes(this.correlationId), 0, result, 2, 16);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TcpPackage{");
        sb.append("command=").append((Object)this.command);
        sb.append(", flag=").append((Object)this.flag);
        sb.append(", correlationId=").append(this.correlationId);
        sb.append(", login='").append(this.login).append('\'');
        sb.append(", password='").append(this.password).append('\'');
        sb.append(", data=").append(Arrays.toString(this.data));
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private TcpCommand command;
        private TcpFlag flag;
        private UUID correlationId;
        private String login;
        private String password;
        private byte[] data;

        private Builder() {
        }

        public Builder command(TcpCommand command) {
            this.command = command;
            return this;
        }

        public Builder flag(TcpFlag flag) {
            this.flag = flag;
            return this;
        }

        public Builder correlationId(UUID correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public Builder login(String login) {
            this.login = login;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public TcpPackage build() {
            Preconditions.checkNotNull(this.command, "TCP command is not provided.");
            if (this.flag == null) {
                this.flag = TcpFlag.None;
            }
            Preconditions.checkNotNull(this.correlationId, "Correlation ID is not provided.");
            if (this.flag == TcpFlag.Authenticated) {
                Preconditions.checkNotNull(this.login, "Login is not provided for authorized TcpPackage.");
                Preconditions.checkNotNull(this.password, "Password is not provided for authorized TcpPackage.");
            } else {
                Preconditions.checkArgument(this.login == null, "Login provided for non-authorized TcpPackage.");
                Preconditions.checkArgument(this.password == null, "Password provided for non-authorized TcpPackage.");
            }
            if (this.data == null) {
                this.data = EmptyArrays.EMPTY_BYTES;
            }
            return new TcpPackage(this);
        }
    }
}

