/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.tcp;

import com.github.msemys.esjc.util.Numbers;
import com.github.msemys.esjc.util.Preconditions;
import java.time.Duration;

public class TcpSettings {
    public final Duration connectTimeout;
    public final Duration closeTimeout;
    public final boolean keepAlive;
    public final boolean noDelay;
    public final int sendBufferSize;
    public final int receiveBufferSize;
    public final int writeBufferLowWaterMark;
    public final int writeBufferHighWaterMark;

    private TcpSettings(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.closeTimeout = builder.closeTimeout;
        this.keepAlive = builder.keepAlive;
        this.noDelay = builder.noDelay;
        this.sendBufferSize = builder.sendBufferSize;
        this.receiveBufferSize = builder.receiveBufferSize;
        this.writeBufferHighWaterMark = builder.writeBufferHighWaterMark;
        this.writeBufferLowWaterMark = builder.writeBufferLowWaterMark;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TcpSettings{");
        sb.append("connectTimeout=").append(this.connectTimeout);
        sb.append(", closeTimeout=").append(this.closeTimeout);
        sb.append(", keepAlive=").append(this.keepAlive);
        sb.append(", noDelay=").append(this.noDelay);
        sb.append(", sendBufferSize=").append(this.sendBufferSize);
        sb.append(", receiveBufferSize=").append(this.receiveBufferSize);
        sb.append(", writeBufferLowWaterMark=").append(this.writeBufferLowWaterMark);
        sb.append(", writeBufferHighWaterMark=").append(this.writeBufferHighWaterMark);
        sb.append('}');
        return sb.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Duration connectTimeout;
        private Duration closeTimeout;
        private Boolean keepAlive;
        private Boolean noDelay;
        private Integer sendBufferSize;
        private Integer receiveBufferSize;
        private Integer writeBufferHighWaterMark;
        private Integer writeBufferLowWaterMark;

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder closeTimeout(Duration closeTimeout) {
            this.closeTimeout = closeTimeout;
            return this;
        }

        public Builder keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder noDelay(boolean noDelay) {
            this.noDelay = noDelay;
            return this;
        }

        public Builder sendBufferSize(int sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
            return this;
        }

        public Builder receiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return this;
        }

        public Builder writeBufferHighWaterMark(int writeBufferHighWaterMark) {
            this.writeBufferHighWaterMark = writeBufferHighWaterMark;
            return this;
        }

        public Builder writeBufferLowWaterMark(int writeBufferLowWaterMark) {
            this.writeBufferLowWaterMark = writeBufferLowWaterMark;
            return this;
        }

        public TcpSettings build() {
            if (this.connectTimeout == null) {
                this.connectTimeout = Duration.ofSeconds(10L);
            }
            if (this.closeTimeout == null) {
                this.closeTimeout = Duration.ofMillis(500L);
            }
            if (this.keepAlive == null) {
                this.keepAlive = true;
            }
            if (this.noDelay == null) {
                this.noDelay = true;
            }
            if (this.sendBufferSize == null) {
                this.sendBufferSize = 65536;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.sendBufferSize), "sendBufferSize should be positive");
            }
            if (this.receiveBufferSize == null) {
                this.receiveBufferSize = 65536;
            } else {
                Preconditions.checkArgument(Numbers.isPositive(this.receiveBufferSize), "receiveBufferSize should be positive");
            }
            if (this.writeBufferHighWaterMark == null) {
                this.writeBufferHighWaterMark = 65536;
            } else {
                Preconditions.checkArgument(!Numbers.isNegative(this.writeBufferHighWaterMark), "writeBufferHighWaterMark should not be negative");
            }
            if (this.writeBufferLowWaterMark == null) {
                this.writeBufferLowWaterMark = 32768;
            } else {
                Preconditions.checkArgument(!Numbers.isNegative(this.writeBufferLowWaterMark), "writeBufferLowWaterMark should not be negative");
            }
            return new TcpSettings(this);
        }
    }
}

