/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.tcp.handler;

import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.tcp.TcpFlag;
import com.github.msemys.esjc.tcp.TcpPackage;
import com.github.msemys.esjc.tcp.handler.AuthenticationEvent;
import com.github.msemys.esjc.util.Preconditions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationHandler
extends SimpleChannelInboundHandler<TcpPackage> {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationHandler.class);
    private final UserCredentials userCredentials;
    private final long timeoutMillis;
    private volatile ScheduledFuture<?> timeoutTask;
    private UUID correlationId;
    private Consumer<AuthenticationStatus> completionConsumer;

    public AuthenticationHandler(UserCredentials userCredentials, Duration timeout) {
        this.userCredentials = userCredentials;
        this.timeoutMillis = timeout.toMillis();
    }

    protected void channelRead0(ChannelHandlerContext ctx, TcpPackage msg) throws Exception {
        if (this.timeoutTask != null && !this.timeoutTask.isDone() && msg.correlationId.equals(this.correlationId)) {
            switch (msg.command) {
                case Authenticated: {
                    this.cancelTimeoutTask();
                    this.complete(ctx, AuthenticationStatus.SUCCESS);
                    break;
                }
                case NotAuthenticated: {
                    this.cancelTimeoutTask();
                    this.complete(ctx, AuthenticationStatus.FAILED);
                    ctx.close();
                }
            }
        } else {
            ctx.fireChannelRead((Object)msg);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.userCredentials != null) {
            this.correlationId = UUID.randomUUID();
            ctx.writeAndFlush((Object)TcpPackage.newBuilder().command(TcpCommand.Authenticate).flag(TcpFlag.Authenticated).correlationId(this.correlationId).login(this.userCredentials.username).password(this.userCredentials.password).build());
            this.timeoutTask = ctx.executor().schedule(() -> {
                this.complete(ctx, AuthenticationStatus.TIMEOUT);
                ctx.close();
            }, this.timeoutMillis, TimeUnit.MILLISECONDS);
        } else {
            ctx.fireChannelActive();
            this.complete(ctx, AuthenticationStatus.IGNORED);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cancelTimeoutTask();
    }

    public AuthenticationHandler whenComplete(Consumer<AuthenticationStatus> consumer) {
        Preconditions.checkNotNull(consumer, "consumer is null");
        this.completionConsumer = consumer;
        return this;
    }

    private void complete(ChannelHandlerContext ctx, AuthenticationStatus status) {
        logger.info("Authentication {}", (Object)status);
        ctx.channel().pipeline().remove((ChannelHandler)this);
        if (this.completionConsumer != null) {
            this.completionConsumer.accept(status);
        }
        ctx.fireUserEventTriggered((Object)new AuthenticationEvent(status));
    }

    private void cancelTimeoutTask() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel(true);
            this.timeoutTask = null;
        }
    }

    public static enum AuthenticationStatus {
        SUCCESS,
        FAILED,
        TIMEOUT,
        IGNORED;

    }
}

