/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.tcp.handler;

import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.tcp.TcpPackage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatHandler
extends SimpleChannelInboundHandler<TcpPackage> {
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatHandler.class);
    private final long timeoutMillis;
    private ScheduledFuture<?> timeoutTask;
    private final Object timeoutTaskLock = new Object();

    public HeartbeatHandler(Duration timeout) {
        this.timeoutMillis = timeout.toMillis();
    }

    protected void channelRead0(ChannelHandlerContext ctx, TcpPackage msg) throws Exception {
        switch (msg.command) {
            case HeartbeatRequestCommand: {
                ctx.writeAndFlush((Object)TcpPackage.newBuilder().command(TcpCommand.HeartbeatResponseCommand).correlationId(msg.correlationId).build());
                break;
            }
            case HeartbeatResponseCommand: {
                this.cancelTimeoutTask();
                break;
            }
            default: {
                ctx.fireChannelRead((Object)msg);
            }
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cancelTimeoutTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            Object object = this.timeoutTaskLock;
            synchronized (object) {
                if (this.timeoutTask == null) {
                    ctx.writeAndFlush((Object)TcpPackage.newBuilder().command(TcpCommand.HeartbeatRequestCommand).correlationId(UUID.randomUUID()).build());
                    this.timeoutTask = ctx.executor().schedule(() -> {
                        logger.info("Closing TCP connection [{}, L{}] due to HEARTBEAT TIMEOUT.", (Object)ctx.channel().remoteAddress(), (Object)ctx.channel().localAddress());
                        ctx.close();
                    }, this.timeoutMillis, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimeoutTask() {
        Object object = this.timeoutTaskLock;
        synchronized (object) {
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(true);
                this.timeoutTask = null;
            }
        }
    }
}

