/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.tcp.handler;

import com.github.msemys.esjc.proto.EventStoreClientMessages;
import com.github.msemys.esjc.tcp.TcpCommand;
import com.github.msemys.esjc.tcp.TcpPackage;
import com.github.msemys.esjc.tcp.handler.AuthenticationEvent;
import com.github.msemys.esjc.tcp.handler.AuthenticationHandler;
import com.github.msemys.esjc.util.Preconditions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentificationHandler
extends SimpleChannelInboundHandler<TcpPackage> {
    private static final Logger logger = LoggerFactory.getLogger(IdentificationHandler.class);
    private static final int CLIENT_VERSION = 1;
    private final String connectionName;
    private final long timeoutMillis;
    private ScheduledFuture<?> timeoutTask;
    private final Object timeoutTaskLock = new Object();
    private UUID correlationId;
    private Consumer<IdentificationStatus> completionConsumer;

    public IdentificationHandler(String connectionName, Duration timeout) {
        this.connectionName = connectionName;
        this.timeoutMillis = timeout.toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, TcpPackage msg) throws Exception {
        boolean isClientIdentificationResponse;
        Object object = this.timeoutTaskLock;
        synchronized (object) {
            isClientIdentificationResponse = this.timeoutTask != null && !this.timeoutTask.isDone() && msg.correlationId.equals(this.correlationId);
        }
        if (isClientIdentificationResponse) {
            switch (msg.command) {
                case ClientIdentified: {
                    this.cancelTimeoutTask();
                    this.complete(ctx, IdentificationStatus.SUCCESS);
                    break;
                }
                default: {
                    this.cancelTimeoutTask();
                    this.complete(ctx, IdentificationStatus.FAILED);
                    ctx.close();
                    break;
                }
            }
        } else {
            ctx.fireChannelRead((Object)msg);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cancelTimeoutTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        AuthenticationHandler.AuthenticationStatus authenticationStatus;
        if (evt instanceof AuthenticationEvent && ((authenticationStatus = ((AuthenticationEvent)evt).status) == AuthenticationHandler.AuthenticationStatus.SUCCESS || authenticationStatus == AuthenticationHandler.AuthenticationStatus.IGNORED)) {
            Object object = this.timeoutTaskLock;
            synchronized (object) {
                if (this.timeoutTask == null) {
                    this.correlationId = UUID.randomUUID();
                    ctx.writeAndFlush((Object)TcpPackage.newBuilder().command(TcpCommand.IdentifyClient).correlationId(this.correlationId).data(EventStoreClientMessages.IdentifyClient.newBuilder().setVersion(1).setConnectionName(this.connectionName).build().toByteArray()).build());
                    this.timeoutTask = ctx.executor().schedule(() -> {
                        this.complete(ctx, IdentificationStatus.TIMEOUT);
                        ctx.close();
                    }, this.timeoutMillis, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    public IdentificationHandler whenComplete(Consumer<IdentificationStatus> consumer) {
        Preconditions.checkNotNull(consumer, "consumer is null");
        this.completionConsumer = consumer;
        return this;
    }

    private void complete(ChannelHandlerContext ctx, IdentificationStatus status) {
        logger.info("Identification [{}] {}", (Object)this.connectionName, (Object)status);
        ctx.channel().pipeline().remove((ChannelHandler)this);
        if (this.completionConsumer != null) {
            this.completionConsumer.accept(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimeoutTask() {
        Object object = this.timeoutTaskLock;
        synchronized (object) {
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(true);
                this.timeoutTask = null;
                this.correlationId = null;
            }
        }
    }

    public static enum IdentificationStatus {
        SUCCESS,
        FAILED,
        TIMEOUT;

    }
}

