/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.tcp.handler;

import com.github.msemys.esjc.EventStoreException;
import com.github.msemys.esjc.node.NodeEndpoints;
import com.github.msemys.esjc.operation.InspectionResult;
import com.github.msemys.esjc.operation.manager.OperationItem;
import com.github.msemys.esjc.operation.manager.OperationManager;
import com.github.msemys.esjc.subscription.manager.SubscriptionItem;
import com.github.msemys.esjc.subscription.manager.SubscriptionManager;
import com.github.msemys.esjc.tcp.TcpPackage;
import com.github.msemys.esjc.util.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationHandler
extends SimpleChannelInboundHandler<TcpPackage> {
    private static final Logger logger = LoggerFactory.getLogger(OperationHandler.class);
    private final OperationManager operationManager;
    private final SubscriptionManager subscriptionManager;
    private Consumer<TcpPackage> badRequestConsumer;
    private Consumer<Throwable> channelErrorConsumer;
    private Consumer<NodeEndpoints> reconnectConsumer;

    public OperationHandler(OperationManager operationManager, SubscriptionManager subscriptionManager) {
        this.operationManager = operationManager;
        this.subscriptionManager = subscriptionManager;
    }

    protected void channelRead0(ChannelHandlerContext ctx, TcpPackage msg) throws Exception {
        block0 : switch (msg.command) {
            case BadRequest: {
                if (msg.correlationId == null) {
                    if (this.badRequestConsumer == null) break;
                    this.badRequestConsumer.accept(msg);
                    break;
                }
            }
            default: {
                Optional<OperationItem> operationItem = this.operationManager.getActiveOperation(msg.correlationId);
                if (operationItem.isPresent()) {
                    OperationItem item = operationItem.get();
                    InspectionResult result = item.operation.inspect(msg);
                    logger.debug("HandleTcpPackage OPERATION DECISION {} ({}), {}", new Object[]{result.decision, result.description, item});
                    switch (result.decision) {
                        case DoNothing: {
                            break;
                        }
                        case EndOperation: {
                            this.operationManager.removeOperation(item);
                            break;
                        }
                        case Retry: {
                            this.operationManager.scheduleOperationRetry(item);
                            break;
                        }
                        case Reconnect: {
                            this.reconnectTo(new NodeEndpoints(result.address, result.secureAddress));
                            this.operationManager.scheduleOperationRetry(item);
                            break;
                        }
                        default: {
                            throw new EventStoreException("Unknown InspectionDecision: " + (Object)((Object)result.decision));
                        }
                    }
                    this.operationManager.scheduleWaitingOperations(ctx.channel());
                    break;
                }
                Optional<SubscriptionItem> subscriptionItem = this.subscriptionManager.getActiveSubscription(msg.correlationId);
                if (subscriptionItem.isPresent()) {
                    SubscriptionItem item = subscriptionItem.get();
                    InspectionResult result = item.operation.inspect(msg);
                    logger.debug("HandleTcpPackage SUBSCRIPTION DECISION {} ({}), {}", new Object[]{result.decision, result.description, item});
                    switch (result.decision) {
                        case DoNothing: {
                            break block0;
                        }
                        case EndOperation: {
                            this.subscriptionManager.removeSubscription(item);
                            break block0;
                        }
                        case Retry: {
                            this.subscriptionManager.scheduleSubscriptionRetry(item);
                            break block0;
                        }
                        case Reconnect: {
                            this.reconnectTo(new NodeEndpoints(result.address, result.secureAddress));
                            this.subscriptionManager.scheduleSubscriptionRetry(item);
                            break block0;
                        }
                        case Subscribed: {
                            item.isSubscribed = true;
                            break block0;
                        }
                    }
                    throw new EventStoreException("Unknown InspectionDecision: " + (Object)((Object)result.decision));
                }
                logger.debug("HandleTcpPackage UNMAPPED PACKAGE with CorrelationId {}, Command: {}", (Object)msg.correlationId, (Object)msg.command);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.channelErrorConsumer != null) {
            this.channelErrorConsumer.accept(cause);
        }
    }

    public OperationHandler whenBadRequest(Consumer<TcpPackage> consumer) {
        Preconditions.checkNotNull(consumer, "consumer is null");
        this.badRequestConsumer = consumer;
        return this;
    }

    public OperationHandler whenChannelError(Consumer<Throwable> consumer) {
        Preconditions.checkNotNull(consumer, "consumer is null");
        this.channelErrorConsumer = consumer;
        return this;
    }

    public OperationHandler whenReconnect(Consumer<NodeEndpoints> consumer) {
        Preconditions.checkNotNull(consumer, "consumer is null");
        this.reconnectConsumer = consumer;
        return this;
    }

    private void reconnectTo(NodeEndpoints endPoints) {
        if (this.reconnectConsumer != null) {
            this.reconnectConsumer.accept(endPoints);
        }
    }
}

