/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.user;

import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.http.HttpClient;
import com.github.msemys.esjc.user.UserManager;
import com.github.msemys.esjc.user.UserManagerHttp;
import java.net.InetSocketAddress;
import java.time.Duration;

public class UserManagerBuilder {
    private final HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
    private UserCredentials userCredentials;

    private UserManagerBuilder() {
    }

    public static UserManagerBuilder newBuilder() {
        return new UserManagerBuilder();
    }

    public UserManagerBuilder address(String host, int port) {
        this.httpClientBuilder.address(host, port);
        return this;
    }

    public UserManagerBuilder address(InetSocketAddress address) {
        this.httpClientBuilder.address(address);
        return this;
    }

    public UserManagerBuilder connectTimeout(Duration connectTimeout) {
        this.httpClientBuilder.connectTimeout(connectTimeout);
        return this;
    }

    public UserManagerBuilder operationTimeout(Duration operationTimeout) {
        this.httpClientBuilder.operationTimeout(operationTimeout);
        return this;
    }

    public UserManagerBuilder maxContentLength(int maxContentLength) {
        this.httpClientBuilder.maxContentLength(maxContentLength);
        return this;
    }

    public UserManagerBuilder userCredentials(UserCredentials userCredentials) {
        this.userCredentials = userCredentials;
        return this;
    }

    public UserManagerBuilder userCredentials(String username, String password) {
        return this.userCredentials(new UserCredentials(username, password));
    }

    public UserManagerBuilder noUserCredentials() {
        return this.userCredentials(null);
    }

    public UserManager build() {
        return new UserManagerHttp(this.httpClientBuilder.build(), this.userCredentials);
    }
}

