/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.user;

import com.github.msemys.esjc.UserCredentials;
import com.github.msemys.esjc.http.HttpClient;
import com.github.msemys.esjc.user.User;
import com.github.msemys.esjc.user.UserConflictException;
import com.github.msemys.esjc.user.UserException;
import com.github.msemys.esjc.user.UserManager;
import com.github.msemys.esjc.user.UserNotFoundException;
import com.github.msemys.esjc.user.dto.ChangePasswordDetails;
import com.github.msemys.esjc.user.dto.ResetPasswordDetails;
import com.github.msemys.esjc.user.dto.UserCreateDetails;
import com.github.msemys.esjc.user.dto.UserHolder;
import com.github.msemys.esjc.user.dto.UserUpdateDetails;
import com.github.msemys.esjc.user.dto.UsersHolder;
import com.github.msemys.esjc.util.Preconditions;
import com.github.msemys.esjc.util.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class UserManagerHttp
implements UserManager {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(OffsetDateTime.class, (json, type, ctx) -> OffsetDateTime.parse(json.getAsJsonPrimitive().getAsString())).create();
    private final HttpClient client;
    private final UserCredentials userCredentials;

    protected UserManagerHttp(HttpClient client, UserCredentials userCredentials) {
        Preconditions.checkNotNull(client, "client is null");
        this.client = client;
        this.userCredentials = userCredentials;
    }

    @Override
    public CompletableFuture<Void> enable(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.post(UserManagerHttp.userUri(name) + "/command/enable", "", userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<Void> disable(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.post(UserManagerHttp.userUri(name) + "/command/disable", "", userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<Void> delete(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.delete(UserManagerHttp.userUri(name), userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<List<User>> findAll(UserCredentials userCredentials) {
        return this.get("/users/", userCredentials, HttpResponseStatus.OK).thenApply(UserManagerHttp::asUserList);
    }

    @Override
    public CompletableFuture<User> find(String name, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        return this.get(UserManagerHttp.userUri(name), userCredentials, HttpResponseStatus.OK).thenApply(UserManagerHttp::asUser);
    }

    @Override
    public CompletableFuture<User> getCurrent(UserCredentials userCredentials) {
        return this.get("/users/$current", userCredentials, HttpResponseStatus.OK).thenApply(UserManagerHttp::asUser);
    }

    @Override
    public CompletableFuture<Void> create(String name, String fullName, String password, List<String> groups, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(fullName), "fullName is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(password), "password is null or empty");
        Preconditions.checkNotNull(groups, "groups is null");
        return this.post("/users/", gson.toJson((Object)new UserCreateDetails(name, fullName, password, groups)), userCredentials, HttpResponseStatus.CREATED);
    }

    @Override
    public CompletableFuture<Void> update(String name, String fullName, List<String> groups, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(fullName), "fullName is null or empty");
        Preconditions.checkNotNull(groups, "groups is null");
        return this.put(UserManagerHttp.userUri(name), gson.toJson((Object)new UserUpdateDetails(fullName, groups)), userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<Void> changePassword(String name, String oldPassword, String newPassword, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(oldPassword), "oldPassword is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(newPassword), "newPassword is null or empty");
        return this.post(UserManagerHttp.userUri(name) + "/command/change-password", gson.toJson((Object)new ChangePasswordDetails(oldPassword, newPassword)), userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public CompletableFuture<Void> resetPassword(String name, String newPassword, UserCredentials userCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(newPassword), "newPassword is null or empty");
        return this.post(UserManagerHttp.userUri(name) + "/command/reset-password", gson.toJson((Object)new ResetPasswordDetails(newPassword)), userCredentials, HttpResponseStatus.OK);
    }

    @Override
    public void shutdown() {
        this.client.close();
    }

    private CompletableFuture<String> get(String uri, UserCredentials userCredentials, HttpResponseStatus expectedStatus) {
        FullHttpRequest request = HttpClient.newRequest(HttpMethod.GET, uri, this.defaultOr(userCredentials));
        return this.client.send((HttpRequest)request).thenApply(response -> {
            if (response.status().code() == expectedStatus.code()) {
                return response.content().toString(StandardCharsets.UTF_8);
            }
            if (response.status().code() == HttpResponseStatus.NOT_FOUND.code()) {
                throw new UserNotFoundException((HttpRequest)request, (FullHttpResponse)response);
            }
            throw new UserException((HttpRequest)request, (FullHttpResponse)response);
        });
    }

    private CompletableFuture<Void> delete(String uri, UserCredentials userCredentials, HttpResponseStatus expectedStatus) {
        FullHttpRequest request = HttpClient.newRequest(HttpMethod.DELETE, uri, this.defaultOr(userCredentials));
        return this.client.send((HttpRequest)request).thenAccept(response -> {
            if (response.status().code() == HttpResponseStatus.NOT_FOUND.code()) {
                throw new UserNotFoundException((HttpRequest)request, (FullHttpResponse)response);
            }
            if (response.status().code() != expectedStatus.code()) {
                throw new UserException((HttpRequest)request, (FullHttpResponse)response);
            }
        });
    }

    private CompletableFuture<Void> put(String uri, String content, UserCredentials userCredentials, HttpResponseStatus expectedStatus) {
        FullHttpRequest request = HttpClient.newRequest(HttpMethod.PUT, uri, content, (CharSequence)HttpHeaderValues.APPLICATION_JSON, this.defaultOr(userCredentials));
        return this.client.send((HttpRequest)request).thenAccept(response -> {
            if (response.status().code() == HttpResponseStatus.NOT_FOUND.code()) {
                throw new UserNotFoundException((HttpRequest)request, (FullHttpResponse)response);
            }
            if (response.status().code() != expectedStatus.code()) {
                throw new UserException((HttpRequest)request, (FullHttpResponse)response);
            }
        });
    }

    private CompletableFuture<Void> post(String uri, String content, UserCredentials userCredentials, HttpResponseStatus expectedStatus) {
        FullHttpRequest request = HttpClient.newRequest(HttpMethod.POST, uri, content, (CharSequence)HttpHeaderValues.APPLICATION_JSON, this.defaultOr(userCredentials));
        return this.client.send((HttpRequest)request).thenAccept(response -> {
            if (response.status().code() == HttpResponseStatus.NOT_FOUND.code()) {
                throw new UserNotFoundException((HttpRequest)request, (FullHttpResponse)response);
            }
            if (response.status().code() == HttpResponseStatus.CONFLICT.code()) {
                throw new UserConflictException((HttpRequest)request, (FullHttpResponse)response);
            }
            if (response.status().code() != expectedStatus.code()) {
                throw new UserException((HttpRequest)request, (FullHttpResponse)response);
            }
        });
    }

    private UserCredentials defaultOr(UserCredentials userCredentials) {
        return userCredentials == null ? this.userCredentials : userCredentials;
    }

    private static List<User> asUserList(String json) {
        if (Strings.isNullOrEmpty(json)) {
            return Collections.emptyList();
        }
        UsersHolder holder = (UsersHolder)gson.fromJson(json, UsersHolder.class);
        return holder.data != null ? holder.data : Collections.emptyList();
    }

    private static User asUser(String json) {
        return Strings.isNullOrEmpty(json) ? null : ((UserHolder)UserManagerHttp.gson.fromJson((String)json, UserHolder.class)).data;
    }

    private static String userUri(String name) {
        return "/users/" + name.trim();
    }
}

