/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.util;

import com.github.msemys.esjc.util.Preconditions;

public class IntRange {
    public final int min;
    public final int max;
    public final Type type;
    private String string;

    IntRange(int min, int max, Type type) {
        if (type == Type.OPEN) {
            Preconditions.checkArgument(min < max, "min should be less than max");
        } else {
            Preconditions.checkArgument(min <= max, "min should be less or equal to max");
        }
        this.min = min;
        this.max = max;
        this.type = type;
    }

    public boolean contains(int value) {
        switch (this.type) {
            case OPEN: {
                return this.min < value && value < this.max;
            }
            case CLOSED: {
                return this.min <= value && value <= this.max;
            }
            case OPEN_CLOSED: {
                return this.min < value && value <= this.max;
            }
            case CLOSED_OPEN: {
                return this.min <= value && value < this.max;
            }
        }
        throw new IllegalStateException("Unexpected type: " + (Object)((Object)this.type));
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.type == Type.OPEN || this.type == Type.OPEN_CLOSED ? "(" : "[");
            sb.append(this.min == Integer.MIN_VALUE ? "-infinity" : Integer.valueOf(this.min));
            sb.append("..");
            sb.append(this.max == Integer.MAX_VALUE ? "infinity" : Integer.valueOf(this.max));
            sb.append(this.type == Type.OPEN || this.type == Type.CLOSED_OPEN ? ")" : "]");
            this.string = sb.toString();
        }
        return this.string;
    }

    public static enum Type {
        OPEN,
        CLOSED,
        OPEN_CLOSED,
        CLOSED_OPEN;

    }
}

