/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.util;

import com.github.msemys.esjc.util.Preconditions;
import java.time.Duration;
import java.time.Instant;

public class SystemTime {
    private long nanos;

    private SystemTime(long nanos) {
        this.nanos = nanos;
    }

    public void update() {
        this.nanos = SystemTime.systemNanoTime();
    }

    public long elapsedNanos() {
        return SystemTime.systemNanoTime() - this.nanos;
    }

    public boolean isElapsed(Duration duration) {
        Preconditions.checkNotNull(duration, "duration is null");
        return this.elapsedNanos() > duration.toNanos();
    }

    public String toString() {
        Instant instant = this.nanos > 0L ? Instant.now().minusNanos(this.elapsedNanos()) : Instant.MIN;
        return instant.toString() + "~" + this.nanos;
    }

    public static SystemTime now() {
        return new SystemTime(SystemTime.systemNanoTime());
    }

    public static SystemTime zero() {
        return new SystemTime(0L);
    }

    private static long systemNanoTime() {
        return System.nanoTime();
    }
}

