/*
 * Decompiled with CFR 0.152.
 */
package com.github.msemys.esjc.util.concurrent;

import com.github.msemys.esjc.util.Throwables;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ResettableLatch {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile boolean released;

    public ResettableLatch(boolean released) {
        this.released = released;
    }

    public boolean await(long time, TimeUnit unit) {
        this.lock.lock();
        try {
            boolean bl = this.released || this.condition.await(time, unit);
            return bl;
        }
        catch (InterruptedException e) {
            throw Throwables.propagate(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void release() {
        this.lock.lock();
        try {
            this.condition.signal();
            this.released = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.lock.lock();
        try {
            this.released = false;
        }
        finally {
            this.lock.unlock();
        }
    }
}

