/*
 * Decompiled with CFR 0.152.
 */
package org.nlab.smtp.pool;

import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class PoolConfigs {
    public static GenericObjectPoolConfig defaultConfig() {
        return new GenericObjectPoolConfig();
    }

    public static GenericObjectPoolConfig standardConfig() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setTestOnBorrow(true);
        config.setMinIdle(0);
        config.setMaxIdle(8);
        config.setMaxTotal(8);
        config.setMinEvictableIdleTimeMillis(TimeUnit.MINUTES.toMillis(5L));
        config.setTimeBetweenEvictionRunsMillis(10000L);
        config.setMaxWaitMillis(10000L);
        return config;
    }

    public static GenericObjectPoolConfig standardConfig(int minIdle, int maxIdle, int maxTotal, int maxWaitMillis, int minEvictableIdleTimeMillis, int timeBetweenEvictionRunsMillis) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setTestOnBorrow(true);
        config.setMinIdle(minIdle);
        config.setMaxIdle(maxIdle);
        config.setMaxTotal(maxTotal);
        config.setMinEvictableIdleTimeMillis((long)minEvictableIdleTimeMillis);
        config.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunsMillis);
        config.setMaxWaitMillis((long)maxWaitMillis);
        return config;
    }
}

