/*
 * Decompiled with CFR 0.152.
 */
package org.nlab.smtp.transport.strategy;

import javax.mail.Address;
import javax.mail.NoSuchProviderException;
import javax.mail.Provider;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import org.nlab.smtp.transport.strategy.TransportStrategy;

public class TransportStrategyFactory {
    public static TransportStrategy newSessiontStrategy() {
        return new TransportStrategy(){

            @Override
            public Transport getTransport(Session session) throws NoSuchProviderException {
                return session.getTransport();
            }
        };
    }

    public static TransportStrategy newProtocolStrategy(final String protocol) {
        return new TransportStrategy(){

            @Override
            public Transport getTransport(Session session) throws NoSuchProviderException {
                return session.getTransport(protocol);
            }
        };
    }

    public static TransportStrategy newUrlNameStrategy(final URLName urlName) {
        return new TransportStrategy(){

            @Override
            public Transport getTransport(Session session) throws NoSuchProviderException {
                return session.getTransport(urlName);
            }
        };
    }

    public static TransportStrategy newAddressStrategy(final Address address) {
        return new TransportStrategy(){

            @Override
            public Transport getTransport(Session session) throws NoSuchProviderException {
                return session.getTransport(address);
            }
        };
    }

    public static TransportStrategy newProviderStrategy(final Provider provider) {
        return new TransportStrategy(){

            @Override
            public Transport getTransport(Session session) throws NoSuchProviderException {
                return session.getTransport(provider);
            }
        };
    }
}

