package de.oehme.xtend.contrib;

import com.google.common.annotations.Beta;
import de.oehme.xtend.contrib.BuilderProcessor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.macro.Active;

/**
 * Adds an inner Builder class to this class. The builder will have a fluent setter for each final field and can be
 * initialized from an existing value. The class will both have builder/copier()-method for Java clients and
 * build/copy[]-method for Xtend clients.
 * This annotation assumes that there is a constructor which takes all the fields in the same order they are defined in the class.
 * Integrates well with the {@link Data} annotation.
 */
@Beta
@Target(ElementType.TYPE)
@Active(BuilderProcessor.class)
public @interface Buildable {
}
