package de.oehme.xtend.contrib;

import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class BuilderProcessor extends AbstractClassProcessor {
  @Override
  public void doRegisterGlobals(final ClassDeclaration it, @Extension final RegisterGlobalsContext context) {
    String _builderClassName = this.builderClassName(it);
    ClassDeclaration _findSourceClass = context.findSourceClass(_builderClassName);
    boolean _tripleEquals = (_findSourceClass == null);
    if (_tripleEquals) {
      String _builderClassName_1 = this.builderClassName(it);
      context.registerClass(_builderClassName_1);
    }
  }
  
  @Override
  public void doTransform(final MutableClassDeclaration cls, @Extension final TransformationContext context) {
    String _builderClassName = this.builderClassName(cls);
    final MutableClassDeclaration builder = context.findClass(_builderClassName);
    final Procedure1<MutableClassDeclaration> _function = new Procedure1<MutableClassDeclaration>() {
      @Override
      public void apply(final MutableClassDeclaration it) {
        context.setPrimarySourceElement(it, cls);
        final Procedure1<MutableConstructorDeclaration> _function = new Procedure1<MutableConstructorDeclaration>() {
          @Override
          public void apply(final MutableConstructorDeclaration it) {
            it.setVisibility(Visibility.PRIVATE);
            TypeReference _newSelfTypeReference = context.newSelfTypeReference(cls);
            it.addParameter("other", _newSelfTypeReference);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                {
                  Iterable<? extends FieldDeclaration> _builtFields = BuilderProcessor.this.builtFields(cls, context);
                  for(final FieldDeclaration builtField : _builtFields) {
                    _builder.append("this.");
                    String _simpleName = builtField.getSimpleName();
                    _builder.append(_simpleName, "");
                    _builder.append(" = other.");
                    String _simpleName_1 = builtField.getSimpleName();
                    _builder.append(_simpleName_1, "");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            };
            it.setBody(_client);
            context.setPrimarySourceElement(it, cls);
          }
        };
        it.addConstructor(_function);
        final Procedure1<MutableConstructorDeclaration> _function_1 = new Procedure1<MutableConstructorDeclaration>() {
          @Override
          public void apply(final MutableConstructorDeclaration it) {
            it.setVisibility(Visibility.PRIVATE);
            context.setPrimarySourceElement(it, cls);
          }
        };
        it.addConstructor(_function_1);
        Iterable<? extends FieldDeclaration> _builtFields = BuilderProcessor.this.builtFields(cls, context);
        final Procedure1<FieldDeclaration> _function_2 = new Procedure1<FieldDeclaration>() {
          @Override
          public void apply(final FieldDeclaration builtField) {
            String _simpleName = builtField.getSimpleName();
            final Procedure1<MutableFieldDeclaration> _function = new Procedure1<MutableFieldDeclaration>() {
              @Override
              public void apply(final MutableFieldDeclaration it) {
                TypeReference _type = builtField.getType();
                it.setType(_type);
                context.setPrimarySourceElement(it, builtField);
              }
            };
            it.addField(_simpleName, _function);
            String _simpleName_1 = builtField.getSimpleName();
            final Procedure1<MutableMethodDeclaration> _function_1 = new Procedure1<MutableMethodDeclaration>() {
              @Override
              public void apply(final MutableMethodDeclaration it) {
                TypeReference _newTypeReference = context.newTypeReference(builder);
                it.setReturnType(_newTypeReference);
                String _simpleName = builtField.getSimpleName();
                TypeReference _type = builtField.getType();
                it.addParameter(_simpleName, _type);
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append("this.");
                    String _simpleName = builtField.getSimpleName();
                    _builder.append(_simpleName, "");
                    _builder.append(" = ");
                    String _simpleName_1 = builtField.getSimpleName();
                    _builder.append(_simpleName_1, "");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("return this;");
                    _builder.newLine();
                  }
                };
                it.setBody(_client);
                context.setPrimarySourceElement(it, builtField);
              }
            };
            it.addMethod(_simpleName_1, _function_1);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("set");
            String _simpleName_2 = builtField.getSimpleName();
            String _firstUpper = StringExtensions.toFirstUpper(_simpleName_2);
            _builder.append(_firstUpper, "");
            final Procedure1<MutableMethodDeclaration> _function_2 = new Procedure1<MutableMethodDeclaration>() {
              @Override
              public void apply(final MutableMethodDeclaration it) {
                TypeReference _newTypeReference = context.newTypeReference(builder);
                it.setReturnType(_newTypeReference);
                String _simpleName = builtField.getSimpleName();
                TypeReference _type = builtField.getType();
                it.addParameter(_simpleName, _type);
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append("this.");
                    String _simpleName = builtField.getSimpleName();
                    _builder.append(_simpleName, "");
                    _builder.append(" = ");
                    String _simpleName_1 = builtField.getSimpleName();
                    _builder.append(_simpleName_1, "");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("return this;");
                    _builder.newLine();
                  }
                };
                it.setBody(_client);
                context.setPrimarySourceElement(it, builtField);
              }
            };
            it.addMethod(_builder.toString(), _function_2);
          }
        };
        IterableExtensions.forEach(_builtFields, _function_2);
        final Procedure1<MutableMethodDeclaration> _function_3 = new Procedure1<MutableMethodDeclaration>() {
          @Override
          public void apply(final MutableMethodDeclaration it) {
            TypeReference _newTypeReference = context.newTypeReference(cls);
            it.setReturnType(_newTypeReference);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return new ");
                _builder.append(cls, "");
                _builder.append("(");
                Iterable<? extends FieldDeclaration> _builtFields = BuilderProcessor.this.builtFields(cls, context);
                final Function1<FieldDeclaration, CharSequence> _function = new Function1<FieldDeclaration, CharSequence>() {
                  @Override
                  public CharSequence apply(final FieldDeclaration it) {
                    return it.getSimpleName();
                  }
                };
                String _join = IterableExtensions.join(_builtFields, ", ", _function);
                _builder.append(_join, "");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            };
            it.setBody(_client);
            context.setPrimarySourceElement(it, cls);
          }
        };
        it.addMethod("build", _function_3);
      }
    };
    ObjectExtensions.<MutableClassDeclaration>operator_doubleArrow(builder, _function);
    final Procedure1<MutableMethodDeclaration> _function_1 = new Procedure1<MutableMethodDeclaration>() {
      @Override
      public void apply(final MutableMethodDeclaration it) {
        TypeReference _newTypeReference = context.newTypeReference(builder);
        it.setReturnType(_newTypeReference);
        it.setStatic(true);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return new ");
            _builder.append(builder, "");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
          }
        };
        it.setBody(_client);
        context.setPrimarySourceElement(it, cls);
      }
    };
    cls.addMethod("builder", _function_1);
    final Procedure1<MutableMethodDeclaration> _function_2 = new Procedure1<MutableMethodDeclaration>() {
      @Override
      public void apply(final MutableMethodDeclaration it) {
        TypeReference _newTypeReference = context.newTypeReference(builder);
        it.setReturnType(_newTypeReference);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return new ");
            _builder.append(builder, "");
            _builder.append("(this);");
            _builder.newLineIfNotEmpty();
          }
        };
        it.setBody(_client);
        context.setPrimarySourceElement(it, cls);
      }
    };
    cls.addMethod("copy", _function_2);
    final Procedure1<MutableMethodDeclaration> _function_3 = new Procedure1<MutableMethodDeclaration>() {
      @Override
      public void apply(final MutableMethodDeclaration it) {
        TypeReference _newTypeReference = context.newTypeReference(cls);
        it.setReturnType(_newTypeReference);
        it.setStatic(true);
        TypeReference _newSelfTypeReference = context.newSelfTypeReference(builder);
        TypeReference _newTypeReference_1 = context.newTypeReference(Procedure1.class, _newSelfTypeReference);
        it.addParameter("init", _newTypeReference_1);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("final ");
            _builder.append(builder, "");
            _builder.append(" builder = new ");
            _builder.append(builder, "");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("init.apply(builder);");
            _builder.newLine();
            _builder.append("return builder.build();");
            _builder.newLine();
          }
        };
        it.setBody(_client);
        context.setPrimarySourceElement(it, cls);
      }
    };
    cls.addMethod("build", _function_3);
    final Procedure1<MutableMethodDeclaration> _function_4 = new Procedure1<MutableMethodDeclaration>() {
      @Override
      public void apply(final MutableMethodDeclaration it) {
        TypeReference _newTypeReference = context.newTypeReference(cls);
        it.setReturnType(_newTypeReference);
        TypeReference _newSelfTypeReference = context.newSelfTypeReference(builder);
        TypeReference _newTypeReference_1 = context.newTypeReference(Procedure1.class, _newSelfTypeReference);
        it.addParameter("copier", _newTypeReference_1);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("final ");
            _builder.append(builder, "");
            _builder.append(" builder = new ");
            _builder.append(builder, "");
            _builder.append("(this);");
            _builder.newLineIfNotEmpty();
            _builder.append("copier.apply(builder);");
            _builder.newLine();
            _builder.append("return builder.build();");
            _builder.newLine();
          }
        };
        it.setBody(_client);
        context.setPrimarySourceElement(it, cls);
      }
    };
    cls.addMethod("copy", _function_4);
  }
  
  public String builderClassName(final ClassDeclaration cls) {
    String _qualifiedName = cls.getQualifiedName();
    return (_qualifiedName + ".Builder");
  }
  
  public Iterable<? extends FieldDeclaration> builtFields(final MutableClassDeclaration cls, @Extension final TransformationContext context) {
    Iterable<? extends FieldDeclaration> _xblockexpression = null;
    {
      Element _primarySourceElement = context.getPrimarySourceElement(cls);
      final ClassDeclaration sourceClass = ((ClassDeclaration) _primarySourceElement);
      Iterable<? extends FieldDeclaration> _declaredFields = sourceClass.getDeclaredFields();
      final Function1<FieldDeclaration, Boolean> _function = new Function1<FieldDeclaration, Boolean>() {
        @Override
        public Boolean apply(final FieldDeclaration it) {
          boolean _and = false;
          boolean _and_1 = false;
          boolean _or = false;
          boolean _isFinal = it.isFinal();
          if (_isFinal) {
            _or = true;
          } else {
            boolean _alsoCollectNonFinalFields = BuilderProcessor.this.alsoCollectNonFinalFields(cls, context);
            _or = _alsoCollectNonFinalFields;
          }
          if (!_or) {
            _and_1 = false;
          } else {
            boolean _isStatic = it.isStatic();
            boolean _not = (!_isStatic);
            _and_1 = _not;
          }
          if (!_and_1) {
            _and = false;
          } else {
            boolean _isTransient = it.isTransient();
            boolean _not_1 = (!_isTransient);
            _and = _not_1;
          }
          return Boolean.valueOf(_and);
        }
      };
      _xblockexpression = IterableExtensions.filter(_declaredFields, _function);
    }
    return _xblockexpression;
  }
  
  public boolean alsoCollectNonFinalFields(final ClassDeclaration cls, @Extension final TransformationContext context) {
    Type _findTypeGlobally = context.findTypeGlobally(Data.class);
    AnnotationReference _findAnnotation = cls.findAnnotation(_findTypeGlobally);
    return (_findAnnotation != null);
  }
}
