package de.oehme.xtend.contrib;

import java.util.Arrays;

/**
 * This class is an implementation detail and not fit for general use.
 * It foregoes immutability for pure performance
 */
@SuppressWarnings("all")
public class CacheKey {
  private final Object[] parameters;
  
  public CacheKey(final Object... parameters) {
    this.parameters = parameters;
  }
  
  public Object get(final int index) {
    return this.parameters[index];
  }
  
  @Override
  public boolean equals(final Object obj) {
    boolean _xblockexpression = false;
    {
      if ((obj instanceof CacheKey)) {
        return Arrays.equals(this.parameters, ((CacheKey)obj).parameters);
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  @Override
  public int hashCode() {
    return Arrays.hashCode(this.parameters);
  }
}
