package de.oehme.xtend.contrib;

import com.google.common.annotations.Beta;
import de.oehme.xtend.contrib.CachedProcessor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.concurrent.TimeUnit;
import org.eclipse.xtend.lib.macro.Active;

/**
 * Caches invocations of a method. When the method is called multiple times with the same parameters, a cached result will be returned.
 * Useful for expensive calculations or recursive algorithms.
 * <br>
 * The method must guarantee the following conditions:
 * <ul>
 * 	<li>The method's parameters have meaningful equals/hashcode implementations.</li>
 * 	<li>The result of the method only depends on the parameters or immutable internal state</li>
 * 	<li>The method is referentially transparent (has no externally visible side effects)</li>
 * </ul>
 */
@Beta
@Target(ElementType.METHOD)
@Active(CachedProcessor.class)
public @interface Cached {
  public int maximumSize() default 0;
  public int expireAfterWrite() default 0;
  public int expireAfterAccess() default 0;
  public TimeUnit timeUnit() default TimeUnit.SECONDS;
}
