package de.oehme.xtend.contrib;

import de.oehme.xtend.contrib.MultipleParameterMethodMemoizer;
import de.oehme.xtend.contrib.ParamterlessMethodMemoizer;
import de.oehme.xtend.contrib.SingleParameterMethodMemoizer;
import java.util.List;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class CachedProcessor implements TransformationParticipant<MutableMethodDeclaration> {
  /**
   * This allows you to get the name of the cache field that will be generated for a cached method.
   * This way you can write your own active annotations that add additional features for cached methods.
   */
  public static String cacheFieldName(final MethodDeclaration method) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("_cache_");
    String _simpleName = method.getSimpleName();
    _builder.append(_simpleName, "");
    {
      Iterable<? extends ParameterDeclaration> _parameters = method.getParameters();
      boolean _isEmpty = IterableExtensions.isEmpty(_parameters);
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append("_");
        Iterable<? extends ParameterDeclaration> _parameters_1 = method.getParameters();
        final Function1<ParameterDeclaration, CharSequence> _function = new Function1<ParameterDeclaration, CharSequence>() {
          @Override
          public CharSequence apply(final ParameterDeclaration it) {
            return CachedProcessor.fieldFriendlyName(it);
          }
        };
        String _join = IterableExtensions.join(_parameters_1, "_", _function);
        _builder.append(_join, "");
      }
    }
    return _builder.toString();
  }
  
  private static String fieldFriendlyName(final ParameterDeclaration it) {
    TypeReference _type = it.getType();
    Type _type_1 = _type.getType();
    String _qualifiedName = _type_1.getQualifiedName();
    return _qualifiedName.replaceAll("\\.", "_");
  }
  
  @Override
  public void doTransform(final List<? extends MutableMethodDeclaration> methods, @Extension final TransformationContext context) {
    final Procedure1<MutableMethodDeclaration> _function = new Procedure1<MutableMethodDeclaration>() {
      @Override
      public void apply(final MutableMethodDeclaration it) {
        Iterable<? extends MutableParameterDeclaration> _parameters = it.getParameters();
        int _size = IterableExtensions.size(_parameters);
        switch (_size) {
          case 0:
            ParamterlessMethodMemoizer _paramterlessMethodMemoizer = new ParamterlessMethodMemoizer(it, context);
            _paramterlessMethodMemoizer.generate();
            break;
          case 1:
            SingleParameterMethodMemoizer _singleParameterMethodMemoizer = new SingleParameterMethodMemoizer(it, context);
            _singleParameterMethodMemoizer.generate();
            break;
          default:
            MultipleParameterMethodMemoizer _multipleParameterMethodMemoizer = new MultipleParameterMethodMemoizer(it, context);
            _multipleParameterMethodMemoizer.generate();
            break;
        }
      }
    };
    IterableExtensions.forEach(methods, _function);
  }
}
