package de.oehme.xtend.contrib;

import de.oehme.xtend.contrib.CachedProcessor;
import de.oehme.xtend.contrib.SignatureHelper;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public abstract class MethodMemoizer {
  @Extension
  protected final TransformationContext context;
  
  @Extension
  protected final SignatureHelper signatures;
  
  protected final MutableMethodDeclaration method;
  
  public MethodMemoizer(final MutableMethodDeclaration method, final TransformationContext context) {
    this.method = method;
    this.context = context;
    SignatureHelper _signatureHelper = new SignatureHelper(context);
    this.signatures = _signatureHelper;
  }
  
  public final MutableMethodDeclaration generate() {
    final Procedure1<MutableMethodDeclaration> _function = new Procedure1<MutableMethodDeclaration>() {
      @Override
      public void apply(final MutableMethodDeclaration it) {
        TypeReference _returnType = it.getReturnType();
        boolean _isInferred = _returnType.isInferred();
        if (_isInferred) {
          MethodMemoizer.this.context.addError(it, "Please explicitly specify the return type");
          return;
        }
        TypeReference _returnType_1 = it.getReturnType();
        TypeReference _wrapperIfPrimitive = _returnType_1.getWrapperIfPrimitive();
        it.setReturnType(_wrapperIfPrimitive);
        String _initMethodName = MethodMemoizer.this.initMethodName();
        StringConcatenationClient _cacheCall = MethodMemoizer.this.cacheCall();
        MethodMemoizer.this.signatures.addIndirection(it, _initMethodName, _cacheCall);
        MutableTypeDeclaration _declaringType = it.getDeclaringType();
        final Procedure1<MutableTypeDeclaration> _function = new Procedure1<MutableTypeDeclaration>() {
          @Override
          public void apply(final MutableTypeDeclaration it) {
            String _cacheFieldName = MethodMemoizer.this.cacheFieldName();
            final Procedure1<MutableFieldDeclaration> _function = new Procedure1<MutableFieldDeclaration>() {
              @Override
              public void apply(final MutableFieldDeclaration it) {
                MethodMemoizer.this.context.setPrimarySourceElement(it, MethodMemoizer.this.method);
                boolean _isStatic = MethodMemoizer.this.method.isStatic();
                it.setStatic(_isStatic);
                it.setTransient(true);
                TypeReference _cacheFieldType = MethodMemoizer.this.cacheFieldType();
                it.setType(_cacheFieldType);
                StringConcatenationClient _cacheFieldInit = MethodMemoizer.this.cacheFieldInit();
                it.setInitializer(_cacheFieldInit);
              }
            };
            it.addField(_cacheFieldName, _function);
          }
        };
        ObjectExtensions.<MutableTypeDeclaration>operator_doubleArrow(_declaringType, _function);
      }
    };
    return ObjectExtensions.<MutableMethodDeclaration>operator_doubleArrow(
      this.method, _function);
  }
  
  protected final String initMethodName() {
    StringConcatenation _builder = new StringConcatenation();
    String _simpleName = this.method.getSimpleName();
    _builder.append(_simpleName, "");
    _builder.append("_init");
    return _builder.toString();
  }
  
  protected final String cacheFieldName() {
    return CachedProcessor.cacheFieldName(this.method);
  }
  
  protected final TypeReference objectIfTypeParameter(final TypeReference type) {
    TypeReference _xifexpression = null;
    Type _type = type.getType();
    if ((_type instanceof TypeParameterDeclaration)) {
      _xifexpression = this.context.getObject();
    } else {
      _xifexpression = type;
    }
    return _xifexpression;
  }
  
  protected abstract StringConcatenationClient cacheCall();
  
  protected abstract TypeReference cacheFieldType();
  
  protected abstract StringConcatenationClient cacheFieldInit();
}
