package de.oehme.xtend.contrib;

import de.oehme.xtend.contrib.CacheKey;
import de.oehme.xtend.contrib.ParametrizedMethodMemoizer;
import java.util.List;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class MultipleParameterMethodMemoizer extends ParametrizedMethodMemoizer {
  public MultipleParameterMethodMemoizer(final MutableMethodDeclaration method, final TransformationContext context) {
    super(method, context);
  }
  
  @Override
  protected StringConcatenationClient cacheKeyToParameters() {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          Iterable<? extends MutableParameterDeclaration> _parameters = MultipleParameterMethodMemoizer.this.method.getParameters();
          boolean _hasElements = false;
          for(final MutableParameterDeclaration p : _parameters) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(",", "");
            }
            _builder.append("(");
            TypeReference _type = p.getType();
            TypeReference _wrapperIfPrimitive = _type.getWrapperIfPrimitive();
            TypeReference _objectIfTypeParameter = MultipleParameterMethodMemoizer.this.objectIfTypeParameter(_wrapperIfPrimitive);
            _builder.append(_objectIfTypeParameter, "");
            _builder.append(") key.get(");
            Iterable<? extends MutableParameterDeclaration> _parameters_1 = MultipleParameterMethodMemoizer.this.method.getParameters();
            List<? extends MutableParameterDeclaration> _list = IterableExtensions.toList(_parameters_1);
            int _indexOf = _list.indexOf(p);
            _builder.append(_indexOf, "");
            _builder.append(")");
          }
        }
      }
    };
    return _client;
  }
  
  @Override
  protected StringConcatenationClient parametersToCacheKey() {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("new ");
        TypeReference _cacheKeyType = MultipleParameterMethodMemoizer.this.cacheKeyType();
        _builder.append(_cacheKeyType, "");
        _builder.append("(");
        Iterable<? extends MutableParameterDeclaration> _parameters = MultipleParameterMethodMemoizer.this.method.getParameters();
        final Function1<MutableParameterDeclaration, CharSequence> _function = new Function1<MutableParameterDeclaration, CharSequence>() {
          @Override
          public CharSequence apply(final MutableParameterDeclaration it) {
            return it.getSimpleName();
          }
        };
        String _join = IterableExtensions.join(_parameters, ",", _function);
        _builder.append(_join, "");
        _builder.append(")");
      }
    };
    return _client;
  }
  
  @Override
  protected TypeReference cacheKeyType() {
    return this.context.newTypeReference(CacheKey.class);
  }
}
