package de.oehme.xtend.contrib;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import de.oehme.xtend.contrib.Cached;
import de.oehme.xtend.contrib.MethodMemoizer;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.EnumerationValueDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Uses Guava's LoadingCache to store the return value for each combination of parameters
 */
@SuppressWarnings("all")
public abstract class ParametrizedMethodMemoizer extends MethodMemoizer {
  public ParametrizedMethodMemoizer(final MutableMethodDeclaration method, final TransformationContext context) {
    super(method, context);
  }
  
  @Override
  protected final StringConcatenationClient cacheFieldInit() {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append(CacheBuilder.class, "");
        _builder.append(".newBuilder()");
        _builder.newLineIfNotEmpty();
        {
          int _maximumSize = ParametrizedMethodMemoizer.this.maximumSize();
          boolean _greaterThan = (_maximumSize > 0);
          if (_greaterThan) {
            _builder.append(".maximumSize(");
            int _maximumSize_1 = ParametrizedMethodMemoizer.this.maximumSize();
            _builder.append(_maximumSize_1, "");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          int _expireAfterWrite = ParametrizedMethodMemoizer.this.expireAfterWrite();
          boolean _greaterThan_1 = (_expireAfterWrite > 0);
          if (_greaterThan_1) {
            _builder.append(".expireAfterWrite(");
            int _expireAfterWrite_1 = ParametrizedMethodMemoizer.this.expireAfterWrite();
            _builder.append(_expireAfterWrite_1, "");
            _builder.append(", ");
            _builder.append(TimeUnit.class, "");
            _builder.append(".");
            String _timeUnit = ParametrizedMethodMemoizer.this.timeUnit();
            _builder.append(_timeUnit, "");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          int _expireAfterAccess = ParametrizedMethodMemoizer.this.expireAfterAccess();
          boolean _greaterThan_2 = (_expireAfterAccess > 0);
          if (_greaterThan_2) {
            _builder.append(".expireAfterAccess(");
            int _expireAfterAccess_1 = ParametrizedMethodMemoizer.this.expireAfterAccess();
            _builder.append(_expireAfterAccess_1, "");
            _builder.append(", ");
            _builder.append(TimeUnit.class, "");
            _builder.append(".");
            String _timeUnit_1 = ParametrizedMethodMemoizer.this.timeUnit();
            _builder.append(_timeUnit_1, "");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append(".build(new ");
        _builder.append(CacheLoader.class, "");
        _builder.append("<");
        TypeReference _cacheKeyType = ParametrizedMethodMemoizer.this.cacheKeyType();
        _builder.append(_cacheKeyType, "");
        _builder.append(", ");
        TypeReference _returnType = ParametrizedMethodMemoizer.this.method.getReturnType();
        TypeReference _objectIfTypeParameter = ParametrizedMethodMemoizer.this.objectIfTypeParameter(_returnType);
        _builder.append(_objectIfTypeParameter, "");
        _builder.append(">() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        TypeReference _returnType_1 = ParametrizedMethodMemoizer.this.method.getReturnType();
        TypeReference _objectIfTypeParameter_1 = ParametrizedMethodMemoizer.this.objectIfTypeParameter(_returnType_1);
        _builder.append(_objectIfTypeParameter_1, "\t");
        _builder.append(" load(");
        TypeReference _cacheKeyType_1 = ParametrizedMethodMemoizer.this.cacheKeyType();
        _builder.append(_cacheKeyType_1, "\t");
        _builder.append(" key) throws Exception {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        String _initMethodName = ParametrizedMethodMemoizer.this.initMethodName();
        _builder.append(_initMethodName, "\t\t");
        _builder.append("(");
        StringConcatenationClient _cacheKeyToParameters = ParametrizedMethodMemoizer.this.cacheKeyToParameters();
        _builder.append(_cacheKeyToParameters, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("})");
        _builder.newLine();
      }
    };
    return _client;
  }
  
  @Override
  protected final TypeReference cacheFieldType() {
    TypeReference _cacheKeyType = this.cacheKeyType();
    TypeReference _returnType = this.method.getReturnType();
    TypeReference _objectIfTypeParameter = this.objectIfTypeParameter(_returnType);
    return this.context.newTypeReference(LoadingCache.class, _cacheKeyType, _objectIfTypeParameter);
  }
  
  @Override
  protected final StringConcatenationClient cacheCall() {
    StringConcatenationClient _xblockexpression = null;
    {
      Iterable<? extends MutableParameterDeclaration> _parameters = this.method.getParameters();
      final Function1<MutableParameterDeclaration, String> _function = new Function1<MutableParameterDeclaration, String>() {
        @Override
        public String apply(final MutableParameterDeclaration it) {
          return it.getSimpleName();
        }
      };
      Iterable<String> _map = IterableExtensions.map(_parameters, _function);
      final Set<String> parameterNames = IterableExtensions.<String>toSet(_map);
      String _elvis = null;
      IntegerRange _upTo = new IntegerRange(1, 1000);
      final Function1<Integer, String> _function_1 = new Function1<Integer, String>() {
        @Override
        public String apply(final Integer it) {
          return ("e" + it);
        }
      };
      Iterable<String> _map_1 = IterableExtensions.<Integer, String>map(_upTo, _function_1);
      final Function1<String, Boolean> _function_2 = new Function1<String, Boolean>() {
        @Override
        public Boolean apply(final String it) {
          boolean _contains = parameterNames.contains(it);
          return Boolean.valueOf((!_contains));
        }
      };
      String _findFirst = IterableExtensions.<String>findFirst(_map_1, _function_2);
      if (_findFirst != null) {
        _elvis = _findFirst;
      } else {
        _elvis = "/* Unable to find an exception name after 1000 tries*/";
      }
      final String exceptionName = _elvis;
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("try {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("return (");
          TypeReference _returnType = ParametrizedMethodMemoizer.this.method.getReturnType();
          _builder.append(_returnType, "\t");
          _builder.append(")");
          String _cacheFieldName = ParametrizedMethodMemoizer.this.cacheFieldName();
          _builder.append(_cacheFieldName, "\t");
          _builder.append(".get(");
          StringConcatenationClient _parametersToCacheKey = ParametrizedMethodMemoizer.this.parametersToCacheKey();
          _builder.append(_parametersToCacheKey, "\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("} catch (Throwable ");
          _builder.append(exceptionName, "");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("if (");
          _builder.append(exceptionName, "\t");
          _builder.append(" instanceof ");
          _builder.append(ExecutionException.class, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("|| ");
          _builder.append(exceptionName, "\t\t");
          _builder.append(" instanceof ");
          _builder.append(UncheckedExecutionException.class, "\t\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("|| ");
          _builder.append(exceptionName, "\t\t");
          _builder.append(" instanceof ");
          _builder.append(ExecutionError.class, "\t\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("Throwable cause = ");
          _builder.append(exceptionName, "\t\t");
          _builder.append(".getCause();");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("throw ");
          _builder.append(Exceptions.class, "\t\t");
          _builder.append(".sneakyThrow(cause);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("} else {");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("throw ");
          _builder.append(Exceptions.class, "\t\t");
          _builder.append(".sneakyThrow(");
          _builder.append(exceptionName, "\t\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }
  
  protected final int maximumSize() {
    AnnotationReference _cacheAnnotation = this.cacheAnnotation();
    return _cacheAnnotation.getIntValue("maximumSize");
  }
  
  protected final int expireAfterWrite() {
    AnnotationReference _cacheAnnotation = this.cacheAnnotation();
    return _cacheAnnotation.getIntValue("expireAfterWrite");
  }
  
  protected final int expireAfterAccess() {
    AnnotationReference _cacheAnnotation = this.cacheAnnotation();
    return _cacheAnnotation.getIntValue("expireAfterAccess");
  }
  
  protected final String timeUnit() {
    AnnotationReference _cacheAnnotation = this.cacheAnnotation();
    EnumerationValueDeclaration _enumValue = _cacheAnnotation.getEnumValue("timeUnit");
    return _enumValue.getSimpleName();
  }
  
  protected final AnnotationReference cacheAnnotation() {
    Type _findTypeGlobally = this.context.findTypeGlobally(Cached.class);
    return this.method.findAnnotation(_findTypeGlobally);
  }
  
  protected abstract TypeReference cacheKeyType();
  
  protected abstract StringConcatenationClient parametersToCacheKey();
  
  protected abstract StringConcatenationClient cacheKeyToParameters();
}
