package de.oehme.xtend.contrib;

import de.oehme.xtend.contrib.MethodMemoizer;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;

/**
 * Uses double null check synchronization for multithreaded correctness and performance
 */
@SuppressWarnings("all")
public class ParamterlessMethodMemoizer extends MethodMemoizer {
  public ParamterlessMethodMemoizer(final MutableMethodDeclaration method, final TransformationContext context) {
    super(method, context);
  }
  
  @Override
  protected StringConcatenationClient cacheCall() {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("synchronized(");
        CharSequence _lock = ParamterlessMethodMemoizer.this.lock();
        _builder.append(_lock, "");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (");
        String _cacheFieldName = ParamterlessMethodMemoizer.this.cacheFieldName();
        _builder.append(_cacheFieldName, "\t");
        _builder.append(" == null) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _cacheFieldName_1 = ParamterlessMethodMemoizer.this.cacheFieldName();
        _builder.append(_cacheFieldName_1, "\t\t");
        _builder.append(" = ");
        String _initMethodName = ParamterlessMethodMemoizer.this.initMethodName();
        _builder.append(_initMethodName, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return (");
        TypeReference _returnType = ParamterlessMethodMemoizer.this.method.getReturnType();
        _builder.append(_returnType, "\t");
        _builder.append(") ");
        String _cacheFieldName_2 = ParamterlessMethodMemoizer.this.cacheFieldName();
        _builder.append(_cacheFieldName_2, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    };
    return _client;
  }
  
  @Override
  protected TypeReference cacheFieldType() {
    TypeReference _returnType = this.method.getReturnType();
    return this.objectIfTypeParameter(_returnType);
  }
  
  @Override
  protected StringConcatenationClient cacheFieldInit() {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("null");
      }
    };
    return _client;
  }
  
  public CharSequence lock() {
    CharSequence _xifexpression = null;
    boolean _isStatic = this.method.isStatic();
    if (_isStatic) {
      StringConcatenation _builder = new StringConcatenation();
      MutableTypeDeclaration _declaringType = this.method.getDeclaringType();
      String _simpleName = _declaringType.getSimpleName();
      _builder.append(_simpleName, "");
      _builder.append(".class");
      _xifexpression = _builder;
    } else {
      _xifexpression = "this";
    }
    return _xifexpression;
  }
}
