package de.oehme.xtend.contrib;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@FinalFieldsConstructor
@SuppressWarnings("all")
public class Reflections {
  @Extension
  private final TransformationContext context;
  
  public Iterable<? extends Type> findTypes(final Path packageFolder, final boolean includeSubPackages) {
    LinkedHashSet<Type> _xblockexpression = null;
    {
      Path _sourceFolder = this.context.getSourceFolder(packageFolder);
      Path _relativize = _sourceFolder.relativize(packageFolder);
      String _string = _relativize.toString();
      final String currentPackage = _string.replace("/", ".");
      String _xifexpression = null;
      boolean _isEmpty = currentPackage.isEmpty();
      if (_isEmpty) {
        _xifexpression = "";
      } else {
        _xifexpression = (currentPackage + ".");
      }
      final String packagePrefix = _xifexpression;
      final LinkedHashSet<Type> types = CollectionLiterals.<Type>newLinkedHashSet();
      Iterable<? extends Path> _children = this.context.getChildren(packageFolder);
      final Function1<Path, Boolean> _function = new Function1<Path, Boolean>() {
        @Override
        public Boolean apply(final Path it) {
          boolean _or = false;
          String _fileExtension = it.getFileExtension();
          boolean _equals = Objects.equal(_fileExtension, "xtend");
          if (_equals) {
            _or = true;
          } else {
            String _fileExtension_1 = it.getFileExtension();
            boolean _equals_1 = Objects.equal(_fileExtension_1, "java");
            _or = _equals_1;
          }
          return Boolean.valueOf(_or);
        }
      };
      Iterable<? extends Path> _filter = IterableExtensions.filter(_children, _function);
      final Function1<Path, LinkedHashSet<String>> _function_1 = new Function1<Path, LinkedHashSet<String>>() {
        @Override
        public LinkedHashSet<String> apply(final Path it) {
          return Reflections.this.containedTypes(it, Reflections.this.context);
        }
      };
      Iterable<LinkedHashSet<String>> _map = IterableExtensions.map(_filter, _function_1);
      Iterable<String> _flatten = Iterables.<String>concat(_map);
      final Function1<String, Type> _function_2 = new Function1<String, Type>() {
        @Override
        public Type apply(final String it) {
          return Reflections.this.context.findTypeGlobally((packagePrefix + it));
        }
      };
      Iterable<Type> _map_1 = IterableExtensions.<String, Type>map(_flatten, _function_2);
      Iterable<Type> _filterNull = IterableExtensions.<Type>filterNull(_map_1);
      Iterables.<Type>addAll(types, _filterNull);
      if (includeSubPackages) {
        Iterable<? extends Path> _children_1 = this.context.getChildren(packageFolder);
        final Function1<Path, Boolean> _function_3 = new Function1<Path, Boolean>() {
          @Override
          public Boolean apply(final Path it) {
            return Boolean.valueOf(Reflections.this.context.isFolder(it));
          }
        };
        Iterable<? extends Path> _filter_1 = IterableExtensions.filter(_children_1, _function_3);
        final Function1<Path, Iterable<? extends Type>> _function_4 = new Function1<Path, Iterable<? extends Type>>() {
          @Override
          public Iterable<? extends Type> apply(final Path it) {
            return Reflections.this.findTypes(it, includeSubPackages);
          }
        };
        Iterable<Iterable<? extends Type>> _map_2 = IterableExtensions.map(_filter_1, _function_4);
        Iterable<Type> _flatten_1 = Iterables.<Type>concat(_map_2);
        Iterables.<Type>addAll(types, _flatten_1);
      }
      _xblockexpression = types;
    }
    return _xblockexpression;
  }
  
  private final static Pattern TYPE_PATTERN = Pattern.compile(".*(class|interface|enum|annotation)\\s+([^\\s{]+).*");
  
  private LinkedHashSet<String> containedTypes(final Path file, @Extension final TransformationContext context) {
    LinkedHashSet<String> _xblockexpression = null;
    {
      CharSequence _contents = context.getContents(file);
      final Matcher matcher = Reflections.TYPE_PATTERN.matcher(_contents);
      final LinkedHashSet<String> typeNames = CollectionLiterals.<String>newLinkedHashSet();
      while (matcher.find()) {
        String _group = matcher.group(2);
        typeNames.add(_group);
      }
      _xblockexpression = typeNames;
    }
    return _xblockexpression;
  }
  
  public Reflections(final TransformationContext context) {
    super();
    this.context = context;
  }
}
