package de.oehme.xtend.contrib;

import de.oehme.xtend.contrib.ParametrizedMethodMemoizer;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class SingleParameterMethodMemoizer extends ParametrizedMethodMemoizer {
  public SingleParameterMethodMemoizer(final MutableMethodDeclaration method, final TransformationContext context) {
    super(method, context);
  }
  
  @Override
  protected StringConcatenationClient cacheKeyToParameters() {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("key");
      }
    };
    return _client;
  }
  
  @Override
  protected StringConcatenationClient parametersToCacheKey() {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        MutableParameterDeclaration _parameter = SingleParameterMethodMemoizer.this.parameter();
        String _simpleName = _parameter.getSimpleName();
        _builder.append(_simpleName, "");
      }
    };
    return _client;
  }
  
  @Override
  protected TypeReference cacheKeyType() {
    MutableParameterDeclaration _parameter = this.parameter();
    TypeReference _type = _parameter.getType();
    TypeReference _wrapperIfPrimitive = _type.getWrapperIfPrimitive();
    return this.objectIfTypeParameter(_wrapperIfPrimitive);
  }
  
  private MutableParameterDeclaration parameter() {
    Iterable<? extends MutableParameterDeclaration> _parameters = this.method.getParameters();
    return IterableExtensions.head(_parameters);
  }
}
