package de.oehme.xtend.contrib.localization;

import com.google.common.annotations.Beta;
import de.oehme.xtend.contrib.localization.MessagesProcessor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import org.eclipse.xtend.lib.macro.Active;

/**
 * Generates a statically typed facade in front of Java ResourceBundles.
 * 
 * When annotated on a class called 'MyMessages' it will look for a file called 'MyMessages.properties' in the same
 * directory. For each message key it will create
 * <ul>
 * <li>- a static constant that contains the name of that key</li>
 * <li>- a method that takes as many parameters as the corresponding message has and returns the formatted, localized String</li>
 * </ul>
 * The generated class will have a constructor that takes a Locale and then returns messages in that language using the default
 * ResourceBundle lookup mechanism.
 */
@Beta
@Target(ElementType.TYPE)
@Active(MessagesProcessor.class)
public @interface Messages {
}
