package de.oehme.xtend.contrib.localization;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend.lib.macro.services.TypeReferenceProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class MessagesProcessor extends AbstractClassProcessor {
  @Override
  public void doTransform(final MutableClassDeclaration cls, @Extension final TransformationContext context) {
    try {
      final Procedure1<MutableFieldDeclaration> _function = new Procedure1<MutableFieldDeclaration>() {
        @Override
        public void apply(final MutableFieldDeclaration it) {
          TypeReference _newTypeReference = context.newTypeReference(ResourceBundle.class);
          it.setType(_newTypeReference);
          it.setFinal(true);
          context.setPrimarySourceElement(it, cls);
        }
      };
      final MutableFieldDeclaration bundleField = cls.addField("bundle", _function);
      final Procedure1<MutableConstructorDeclaration> _function_1 = new Procedure1<MutableConstructorDeclaration>() {
        @Override
        public void apply(final MutableConstructorDeclaration it) {
          TypeReference _newTypeReference = context.newTypeReference(Locale.class);
          it.addParameter("locale", _newTypeReference);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("this.bundle = ");
              _builder.append(ResourceBundle.class, "");
              _builder.append(".getBundle(\"");
              String _qualifiedName = cls.getQualifiedName();
              _builder.append(_qualifiedName, "");
              _builder.append("\", locale);");
              _builder.newLineIfNotEmpty();
            }
          };
          it.setBody(_client);
          bundleField.markAsInitializedBy(it);
          context.setPrimarySourceElement(it, cls);
        }
      };
      cls.addConstructor(_function_1);
      final Procedure1<MutableMethodDeclaration> _function_2 = new Procedure1<MutableMethodDeclaration>() {
        @Override
        public void apply(final MutableMethodDeclaration it) {
          TypeReference _string = context.getString();
          it.addParameter("key", _string);
          TypeReference _string_1 = context.getString();
          it.setReturnType(_string_1);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return bundle.getString(key);");
              _builder.newLine();
            }
          };
          it.setBody(_client);
          it.setDocComment("Returns the raw message String for further processing");
          context.setPrimarySourceElement(it, cls);
        }
      };
      cls.addMethod("getMessage", _function_2);
      CompilationUnit _compilationUnit = cls.getCompilationUnit();
      Path _filePath = _compilationUnit.getFilePath();
      Path _parent = _filePath.getParent();
      String _simpleName = cls.getSimpleName();
      String _plus = (_simpleName + ".properties");
      final Path propertyFile = _parent.append(_plus);
      boolean _exists = context.exists(propertyFile);
      boolean _not = (!_exists);
      if (_not) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Property file ");
        _builder.append(propertyFile, "");
        _builder.append(" does not exist");
        context.addError(cls, _builder.toString());
        return;
      }
      InputStream _contentsAsStream = context.getContentsAsStream(propertyFile);
      final PropertyResourceBundle resourceBundle = new PropertyResourceBundle(_contentsAsStream);
      Enumeration<String> _keys = resourceBundle.getKeys();
      UnmodifiableIterator<String> _forEnumeration = Iterators.<String>forEnumeration(_keys);
      final Procedure1<String> _function_3 = new Procedure1<String>() {
        @Override
        public void apply(final String key) {
          final String pattern = resourceBundle.getString(key);
          String _upperCase = key.toUpperCase();
          final Procedure1<MutableFieldDeclaration> _function = new Procedure1<MutableFieldDeclaration>() {
            @Override
            public void apply(final MutableFieldDeclaration it) {
              TypeReference _string = context.getString();
              it.setType(_string);
              it.setVisibility(Visibility.PUBLIC);
              it.setFinal(true);
              it.setStatic(true);
              it.setDocComment(pattern);
              context.setPrimarySourceElement(it, cls);
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("\"");
                  _builder.append(key, "");
                  _builder.append("\"");
                }
              };
              it.setInitializer(_client);
            }
          };
          cls.addField(_upperCase, _function);
          MessageFormat _messageFormat = new MessageFormat(pattern);
          final Format[] patternVariables = _messageFormat.getFormats();
          String _keyToMethodName = MessagesProcessor.this.keyToMethodName(key);
          final Procedure1<MutableMethodDeclaration> _function_1 = new Procedure1<MutableMethodDeclaration>() {
            @Override
            public void apply(final MutableMethodDeclaration it) {
              final Procedure2<Format, Integer> _function = new Procedure2<Format, Integer>() {
                @Override
                public void apply(final Format patternVariable, final Integer index) {
                  TypeReference _argumentType = MessagesProcessor.this.argumentType(patternVariable, context);
                  it.addParameter(("arg" + index), _argumentType);
                }
              };
              IterableExtensions.<Format>forEach(((Iterable<Format>)Conversions.doWrapArray(patternVariables)), _function);
              TypeReference _string = context.getString();
              it.setReturnType(_string);
              it.setDocComment(pattern);
              context.setPrimarySourceElement(it, cls);
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append(String.class, "");
                  _builder.append(" pattern = bundle.getString(\"");
                  _builder.append(key, "");
                  _builder.append("\");");
                  _builder.newLineIfNotEmpty();
                  _builder.append(MessageFormat.class, "");
                  _builder.append(" format = new ");
                  _builder.append(MessageFormat.class, "");
                  _builder.append("(pattern);");
                  _builder.newLineIfNotEmpty();
                  _builder.append("return format.format(new ");
                  _builder.append(Object.class, "");
                  _builder.append("[]{");
                  Iterable<? extends MutableParameterDeclaration> _parameters = it.getParameters();
                  final Function1<MutableParameterDeclaration, CharSequence> _function = new Function1<MutableParameterDeclaration, CharSequence>() {
                    @Override
                    public CharSequence apply(final MutableParameterDeclaration it) {
                      return it.getSimpleName();
                    }
                  };
                  String _join = IterableExtensions.join(_parameters, ", ", _function);
                  _builder.append(_join, "");
                  _builder.append("});");
                  _builder.newLineIfNotEmpty();
                }
              };
              it.setBody(_client);
            }
          };
          cls.addMethod(_keyToMethodName, _function_1);
        }
      };
      IteratorExtensions.<String>forEach(_forEnumeration, _function_3);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public String keyToMethodName(final String key) {
    String _to = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, key);
    return StringExtensions.toFirstLower(_to);
  }
  
  public TypeReference argumentType(final Format format, @Extension final TypeReferenceProvider typeRefs) {
    TypeReference _switchResult = null;
    boolean _matched = false;
    if (!_matched) {
      if (format instanceof NumberFormat) {
        _matched=true;
        _switchResult = typeRefs.newTypeReference(Number.class);
      }
    }
    if (!_matched) {
      if (format instanceof DateFormat) {
        _matched=true;
        _switchResult = typeRefs.newTypeReference(Date.class);
      }
    }
    if (!_matched) {
      _switchResult = typeRefs.getObject();
    }
    return _switchResult;
  }
}
