/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.boot.autoconfigure;

import internal.org.springframework.content.rest.boot.autoconfigure.ContentRestAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.rest.config.ContentRestConfigurer;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.core.annotation.Order;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;

@Order(value=0)
public class SpringBootContentRestConfigurer
implements ContentRestConfigurer {
    @Autowired
    private ContentRestAutoConfiguration.ContentRestProperties properties;

    public SpringBootContentRestConfigurer() {
    }

    public SpringBootContentRestConfigurer(ContentRestAutoConfiguration.ContentRestProperties properties) {
        this.properties = properties;
    }

    public void configure(RestConfiguration config) {
        if (this.properties == null) {
            return;
        }
        if (this.properties.getBaseUri() != null) {
            config.setBaseUri(this.properties.getBaseUri());
        }
        config.setFullyQualifiedLinks(this.properties.fullyQualifiedLinks());
        config.setShortcutLinks(!this.properties.shortcutRequestMappings().disabled());
        if (this.properties.shortcutRequestMappings().excludes() != null) {
            String[] exclusions;
            for (String exclusion : exclusions = this.properties.shortcutRequestMappings().excludes().split(":")) {
                String[] mediaTypes;
                String[] segments = exclusion.split("=");
                if (segments.length != 2) continue;
                String method = segments[0];
                String values = segments[1];
                if (!StringUtils.hasLength((String)values)) continue;
                for (String mediaType : mediaTypes = values.split(",")) {
                    try {
                        config.shortcutExclusions().exclude(method, MediaType.parseMediaType((String)mediaType));
                    }
                    catch (InvalidMediaTypeException invalidMediaTypeException) {
                        // empty catch block
                    }
                }
            }
        }
        config.setOverwriteExistingContent(this.properties.getOverwriteExistingContent());
        config.setSetContentDisposition(this.properties.getSetContentDisposition());
        config.setUnsetContentDisposition(this.properties.getUnsetContentDisposition());
    }
}

