/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.versions.jpa.boot.autoconfigure;

import internal.org.springframework.versions.jpa.boot.autoconfigure.JpaVersionsProperties;
import java.sql.DatabaseMetaData;
import java.util.Collections;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.sql.init.SqlDataSourceScriptDatabaseInitializer;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public class JpaVersionsDatabaseInitializer
extends SqlDataSourceScriptDatabaseInitializer {
    public JpaVersionsDatabaseInitializer(DataSource ds, JpaVersionsProperties properties) {
        super(ds, JpaVersionsDatabaseInitializer.getSettings(properties, ds));
    }

    private static DatabaseInitializationSettings getSettings(JpaVersionsProperties properties, DataSource dataSource) {
        DatabaseInitializationSettings settings = new DatabaseInitializationSettings();
        settings.setSchemaLocations(Collections.singletonList(properties.getSchema().replace("@@platform@@", JpaVersionsDatabaseInitializer.getDatabaseName(dataSource))));
        settings.setContinueOnError(false);
        settings.setMode(properties.getInitializer().getInitializeSchema());
        return settings;
    }

    private static String getDatabaseName(DataSource dataSource) {
        try {
            String productName = JdbcUtils.commonDatabaseName((String)((String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductName)));
            DatabaseDriver databaseDriver = DatabaseDriver.fromProductName((String)productName);
            if (databaseDriver == DatabaseDriver.UNKNOWN) {
                throw new IllegalStateException("Unable to detect database type");
            }
            return databaseDriver.getId();
        }
        catch (MetaDataAccessException ex) {
            throw new IllegalStateException("Unable to detect database type", ex);
        }
    }
}

