/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.renditions.renderers;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.io.CloseableObserver;
import org.springframework.content.commons.io.FileRemover;
import org.springframework.content.commons.io.ObservableInputStream;
import org.springframework.content.commons.renditions.RenditionProvider;
import org.springframework.stereotype.Service;

@Service
public class JpegToPngRenditionProvider
implements RenditionProvider {
    private static final Log logger = LogFactory.getLog(JpegToPngRenditionProvider.class);

    public String consumes() {
        return "image/jpeg";
    }

    public String[] produces() {
        return new String[]{"image/png"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream convert(InputStream fromInputSource, String toMimeType) {
        try {
            File tmpFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
            BufferedImage bufferedImage = ImageIO.read(fromInputSource);
            ImageIO.write((RenderedImage)bufferedImage, "png", tmpFile);
            ObservableInputStream observableInputStream = new ObservableInputStream((InputStream)new FileInputStream(tmpFile), (CloseableObserver)new FileRemover(tmpFile));
            return observableInputStream;
        }
        catch (Exception e) {
            logger.warn((Object)String.format("%s rendition failed", toMimeType), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fromInputSource);
        }
        return null;
    }
}

