/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.renditions.renderers;

import internal.org.springframework.renditions.pdf.PDFServiceImpl;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.springframework.content.commons.io.CloseableObserver;
import org.springframework.content.commons.io.FileRemover;
import org.springframework.content.commons.io.ObservableInputStream;
import org.springframework.content.commons.renditions.RenditionProvider;
import org.springframework.content.renditions.RenditionException;
import org.springframework.renditions.poi.PDFService;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PdfToJpegRenderer
implements RenditionProvider {
    private static Log logger = LogFactory.getLog(PdfToJpegRenderer.class);
    private PDFService pdfService;

    public PdfToJpegRenderer() {
        this.pdfService = new PDFServiceImpl();
    }

    public PdfToJpegRenderer(PDFService pdfService) {
        this.pdfService = pdfService;
    }

    public String consumes() {
        return "application/pdf";
    }

    public String[] produces() {
        return new String[]{"image/jpg"};
    }

    public InputStream convert(InputStream fromInputSource, String toMimeType) {
        block17: {
            Assert.notNull((Object)fromInputSource, (String)"input source must not be null");
            PDDocument document = null;
            try {
                document = this.pdfService.load(fromInputSource);
                PDFRenderer pdfRenderer = this.pdfService.renderer(document);
                if (document.getNumberOfPages() <= 0) break block17;
                BufferedImage bim = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
                File tmp = File.createTempFile("pdftojpegrenderer", ".tmp");
                tmp.deleteOnExit();
                FileOutputStream out = new FileOutputStream(tmp);
                try {
                    this.pdfService.writeImage(bim, "jpeg", out);
                }
                catch (IOException e) {
                    logger.error((Object)"Error writing buffered image to output stream");
                    throw new RenditionException("Error writing buffered image to output stream", e);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
                ObservableInputStream observableInputStream = new ObservableInputStream((InputStream)new FileInputStream(tmp), (CloseableObserver)new FileRemover(tmp));
                return observableInputStream;
            }
            catch (IOException e) {
                logger.error((Object)"Error rendering application/pdf to image/jpeg");
                throw new RenditionException("Error rendering application/pdf to image/jpeg", e);
            }
            finally {
                try {
                    if (document != null) {
                        document.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

