/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers.resolvers;

import internal.org.springframework.content.rest.controllers.resolvers.EntityResolution;
import internal.org.springframework.content.rest.controllers.resolvers.EntityResolver;
import java.util.ArrayList;
import java.util.Comparator;
import org.springframework.util.AntPathMatcher;

public class EntityResolvers
extends ArrayList<EntityResolver> {
    private static final long serialVersionUID = -7652384665879868640L;

    public EntityResolution resolve(String path) {
        AntPathMatcher matcher = new AntPathMatcher();
        Comparator patternComparator = matcher.getPatternComparator(path);
        ArrayList<String> entityUriTemplates = new ArrayList<String>();
        for (EntityResolver resolver : this) {
            if (!matcher.match(resolver.getMapping(), path)) continue;
            entityUriTemplates.add(resolver.getMapping());
        }
        String bestMatch = null;
        if (entityUriTemplates.size() > 1) {
            entityUriTemplates.sort(patternComparator);
        }
        bestMatch = (String)entityUriTemplates.get(0);
        EntityResolver matchedEntityResolver = null;
        for (EntityResolver resolver : this) {
            if (!bestMatch.equals(resolver.getMapping())) continue;
            matchedEntityResolver = resolver;
        }
        return matchedEntityResolver.resolve(path);
    }

    public boolean hasPropertyFor(String path) {
        AntPathMatcher matcher = new AntPathMatcher();
        Comparator patternComparator = matcher.getPatternComparator(path);
        ArrayList<String> entityUriTemplates = new ArrayList<String>();
        for (EntityResolver resolver : this) {
            if (!matcher.match(resolver.getMapping(), path)) continue;
            entityUriTemplates.add(resolver.getMapping());
        }
        String bestMatch = null;
        if (entityUriTemplates.size() > 1) {
            entityUriTemplates.sort(patternComparator);
        }
        bestMatch = (String)entityUriTemplates.get(0);
        EntityResolver matchedEntityResolver = null;
        for (EntityResolver resolver : this) {
            if (!bestMatch.equals(resolver.getMapping())) continue;
            matchedEntityResolver = resolver;
        }
        return matchedEntityResolver.hasPropertyFor(path);
    }
}

