/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.io;

import internal.org.springframework.content.rest.io.AssociatedStoreResource;
import jakarta.persistence.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Date;
import java.util.stream.Stream;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.io.RangeableResource;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.renditions.Renderable;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.HttpResource;

public class AssociatedStoreResourceImpl<S>
implements HttpResource,
AssociatedStoreResource<S> {
    private final ConfigurableConversionService conversionService = new DefaultConversionService();
    private S entity;
    private Resource original;
    private StoreInfo info;
    private ContentProperty contentProperty;
    private PropertyPath propertyPath;

    public AssociatedStoreResourceImpl(StoreInfo info, S entity, PropertyPath propertyPath, ContentProperty property, Resource original) {
        Jsr310Converters.getConvertersToRegister().forEach(arg_0 -> ((ConfigurableConversionService)this.conversionService).addConverter(arg_0));
        this.info = info;
        this.entity = entity;
        this.propertyPath = propertyPath;
        this.contentProperty = property;
        this.original = original;
    }

    @Override
    public StoreInfo getStoreInfo() {
        return this.info;
    }

    @Override
    public S getAssociation() {
        return this.entity;
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public ContentProperty getContentProperty() {
        return this.contentProperty;
    }

    protected Resource getDelegate() {
        return this.original;
    }

    protected ConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public boolean isRenderableAs(MimeType mimeType) {
        if (Renderable.class.isAssignableFrom(this.getStoreInfo().getInterface())) {
            Renderable renderer = (Renderable)this.getStoreInfo().getImplementation(AssociativeStore.class);
            return renderer.hasRendition(this.getAssociation(), this.getPropertyPath(), mimeType.toString());
        }
        return false;
    }

    @Override
    public InputStream renderAs(MimeType mimeType) {
        if (Renderable.class.isAssignableFrom(this.getStoreInfo().getInterface())) {
            Renderable renderer = (Renderable)this.getStoreInfo().getImplementation(AssociativeStore.class);
            return renderer.getRendition(this.getAssociation(), this.getPropertyPath(), mimeType.toString());
        }
        return null;
    }

    @Override
    public Object getETag() {
        Object etag = null;
        if (etag == null) {
            etag = BeanUtils.getFieldWithAnnotation(this.entity, Version.class);
        }
        if (etag == null) {
            etag = "";
        }
        return etag.toString();
    }

    @Override
    public MediaType getMimeType() {
        Object mimeType = null;
        mimeType = this.getContentProperty().getMimeType(this.getAssociation());
        return MediaType.valueOf((String)(mimeType != null ? mimeType.toString() : "*/*"));
    }

    public long contentLength() throws IOException {
        Long contentLength = (Long)this.getContentProperty().getContentLength(this.getAssociation());
        if (contentLength == null) {
            contentLength = this.getDelegate().contentLength();
        }
        return contentLength;
    }

    public long lastModified() throws IOException {
        Object lastModified = null;
        if (lastModified == null && this.getDelegate() != null) {
            return this.getDelegate().lastModified();
        }
        if (lastModified != null) {
            return Stream.of(lastModified).map(it -> (Date)this.getConversionService().convert(it, Date.class)).map(it -> (Instant)this.getConversionService().convert(it, Instant.class)).map(it -> it.toEpochMilli()).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid data type for @LastModifiedDate on Entity %s", this.getAssociation())));
        }
        return -1L;
    }

    public HttpHeaders getResponseHeaders() {
        HttpHeaders headers = new HttpHeaders();
        Object originalFileName = this.getContentProperty().getOriginalFileName(this.getAssociation());
        if (originalFileName != null && StringUtils.hasText((String)originalFileName.toString())) {
            headers.setContentDisposition(ContentDisposition.attachment().filename((String)originalFileName, StandardCharsets.UTF_8).build());
        } else {
            headers.setContentDisposition(ContentDisposition.attachment().build());
        }
        return headers;
    }

    public boolean exists() {
        return this.original != null ? this.original.exists() : false;
    }

    public boolean isReadable() {
        return this.original.isReadable();
    }

    public boolean isOpen() {
        return this.original.isOpen();
    }

    public boolean isFile() {
        return this.original.isFile();
    }

    public URL getURL() throws IOException {
        return this.original.getURL();
    }

    public URI getURI() throws IOException {
        return this.original.getURI();
    }

    public File getFile() throws IOException {
        return this.original.getFile();
    }

    public ReadableByteChannel readableChannel() throws IOException {
        return this.original.readableChannel();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.original.createRelative(relativePath);
    }

    @Nullable
    public String getFilename() {
        return this.original.getFilename();
    }

    public String getDescription() {
        return this.original.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.original.getInputStream();
    }

    public boolean isWritable() {
        return ((WritableResource)this.original).isWritable();
    }

    public OutputStream getOutputStream() throws IOException {
        return ((WritableResource)this.original).getOutputStream();
    }

    public WritableByteChannel writableChannel() throws IOException {
        return ((WritableResource)this.original).writableChannel();
    }

    public void delete() throws IOException {
        ((DeletableResource)this.original).delete();
    }

    public void setRange(String range) {
        if (this.original instanceof RangeableResource) {
            ((RangeableResource)this.original).setRange(range);
        }
    }
}

