/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.mappingcontext;

import internal.org.springframework.content.rest.mappingcontext.RestResourceMappingBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.content.commons.mappingcontext.ClassVisitor;
import org.springframework.content.commons.mappingcontext.ClassWalker;

public class ContentPropertyToRequestMappingContext {
    private Map<Class<?>, Map<String, String>> mappings = new HashMap();

    public Map<String, String> getMappings(Class<?> domainClass) {
        Map<String, String> mappings = this.mappings.get(domainClass);
        if (mappings == null) {
            mappings = this.resolveMappings(domainClass);
        }
        return mappings;
    }

    public boolean hasInverseMapping(Class<?> domainClass, String requestSubPath) {
        Map<String, String> mappings = this.mappings.get(domainClass);
        if (mappings == null) {
            mappings = this.resolveMappings(domainClass);
        }
        return mappings.containsValue(requestSubPath);
    }

    public Map<String, String> getInverseMappings(Class<?> domainClass) {
        Map<String, String> mappings = this.mappings.get(domainClass);
        if (mappings == null) {
            mappings = this.resolveMappings(domainClass);
        }
        return mappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    private Map<String, String> resolveMappings(Class<?> domainClass) {
        RestResourceMappingBuilder visitor = new RestResourceMappingBuilder(restResource -> restResource.path());
        ClassWalker walker = new ClassWalker((ClassVisitor)visitor);
        walker.accept(domainClass);
        Map<String, String> mappings = visitor.getMappings();
        this.mappings.put(domainClass, mappings);
        return mappings;
    }

    public String resolveContentPropertyPath(Class<?> domainClass, String contentPropertyPath) {
        if (this.hasInverseMapping(domainClass, contentPropertyPath)) {
            return this.getInverseMappings(domainClass).get(contentPropertyPath);
        }
        return contentPropertyPath;
    }
}

