/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.rest.config;

import internal.org.springframework.content.commons.storeservice.StoresImpl;
import internal.org.springframework.content.rest.controllers.ResourceHandlerMethodArgumentResolver;
import internal.org.springframework.content.rest.controllers.resolvers.DefaultEntityResolver;
import internal.org.springframework.content.rest.controllers.resolvers.EntityResolvers;
import internal.org.springframework.content.rest.controllers.resolvers.RevisionEntityResolver;
import internal.org.springframework.content.rest.mappingcontext.ContentPropertyToExportedContext;
import internal.org.springframework.content.rest.mappingcontext.ContentPropertyToLinkrelMappingContext;
import internal.org.springframework.content.rest.mappingcontext.ContentPropertyToRequestMappingContext;
import internal.org.springframework.content.rest.mappings.ContentHandlerMapping;
import internal.org.springframework.content.rest.mappings.StoreByteRangeHttpRequestHandler;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.storeservice.StoreResolver;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.content.rest.config.ContentRestConfigurer;
import org.springframework.content.rest.config.SetContentDisposition;
import org.springframework.content.rest.config.StoreCacheControlInterceptor;
import org.springframework.content.rest.config.StoreCorsRegistry;
import org.springframework.content.rest.config.UnsetContentDisposition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.io.Resource;
import org.springframework.data.repository.support.DefaultRepositoryInvokerFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.web.ProxyingHandlerMethodArgumentResolver;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ComponentScan(value={"internal.org.springframework.content.rest.controllers, org.springframework.data.rest.extensions, org.springframework.data.rest.versioning"})
public class RestConfiguration
implements InitializingBean {
    public static boolean OVERWRITE_EXISTING_CONTENT_DEFAULT = true;
    public static SetContentDisposition SETCONTENT_CONTENT_DISPOSITION_DEFAULT = SetContentDisposition.Overwrite;
    public static UnsetContentDisposition UNSETCONTENT_CONTENT_DISPOSITION_DEFAULT = UnsetContentDisposition.Remove;
    public static boolean FULLY_QUALIFIED_DEFAULTS_DEFAULT = true;
    public static boolean SHORTCUT_LINKS_DEFAULT = true;
    private static final URI NO_URI = URI.create("");
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private List<ContentRestConfigurer> configurers = new ArrayList<ContentRestConfigurer>();
    private URI baseUri = NO_URI;
    private StoreCorsRegistry corsRegistry;
    private boolean fullyQualifiedLinks = FULLY_QUALIFIED_DEFAULTS_DEFAULT;
    private boolean shortcutLinks = SHORTCUT_LINKS_DEFAULT;
    private boolean overwriteExistingContent = OVERWRITE_EXISTING_CONTENT_DEFAULT;
    private SetContentDisposition setContentDisposition = SETCONTENT_CONTENT_DISPOSITION_DEFAULT;
    private UnsetContentDisposition unsetContentDisposition = UNSETCONTENT_CONTENT_DISPOSITION_DEFAULT;
    private ConverterRegistry converters = new DefaultConversionService();
    private Map<Class<?>, DomainTypeConfig> domainTypeConfigMap = new HashMap();
    private Exclusions shortcutExclusions = new Exclusions();
    private StoreCacheControlInterceptor storeHandlerInterceptor;
    private StoresImpl stores;

    public RestConfiguration() {
        this.corsRegistry = new StoreCorsRegistry();
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    public boolean fullyQualifiedLinks() {
        return this.fullyQualifiedLinks;
    }

    public void setFullyQualifiedLinks(boolean fullyQualifiedLinks) {
        this.fullyQualifiedLinks = fullyQualifiedLinks;
    }

    public boolean shortcutLinks() {
        return this.shortcutLinks;
    }

    public void setShortcutLinks(boolean shortcutLinks) {
        this.shortcutLinks = shortcutLinks;
    }

    public boolean overwriteExistingContent() {
        return this.overwriteExistingContent;
    }

    public void setOverwriteExistingContent(boolean overwriteExistingContent) {
        this.overwriteExistingContent = overwriteExistingContent;
    }

    public SetContentDisposition getSetContentDisposition() {
        return this.setContentDisposition;
    }

    public void setSetContentDisposition(SetContentDisposition setContentDisposition) {
        this.setContentDisposition = setContentDisposition;
    }

    public UnsetContentDisposition getUnsetContentDisposition() {
        return this.unsetContentDisposition;
    }

    public void setUnsetContentDisposition(UnsetContentDisposition unsetContentDisposition) {
        this.unsetContentDisposition = unsetContentDisposition;
    }

    public StoreCorsRegistry getCorsRegistry() {
        return this.corsRegistry;
    }

    public StoreCacheControlInterceptor getStoreHandlerInterceptor() {
        if (this.storeHandlerInterceptor == null) {
            this.storeHandlerInterceptor = new StoreCacheControlInterceptor();
        }
        return this.storeHandlerInterceptor;
    }

    public Stores getStores() {
        if (this.stores == null) {
            Assert.notNull((Object)this.context, (String)"context should not be null");
            this.stores = new StoresImpl((ListableBeanFactory)this.context);
        }
        return this.stores;
    }

    public void addStoreResolver(String name, StoreResolver resolver) {
        this.getStores().addStoreResolver(name, resolver);
    }

    public StoreCacheControlInterceptor.StoreCacheControlConfigurer cacheControl() {
        return this.getStoreHandlerInterceptor().configurer();
    }

    public DomainTypeConfig forDomainType(Class<?> type) {
        DomainTypeConfig config = this.domainTypeConfigMap.get(type);
        if (config == null) {
            config = new DomainTypeConfig();
            this.domainTypeConfigMap.put(type, config);
        }
        return config;
    }

    public Exclusions shortcutExclusions() {
        return this.shortcutExclusions;
    }

    public ConverterRegistry converters() {
        return this.converters;
    }

    @Bean
    Stores stores() {
        return this.getStores();
    }

    @Bean
    StoreCacheControlInterceptor storeHandlerInterceptor() {
        return this.getStoreHandlerInterceptor();
    }

    @Bean
    MappingContext mappingContext() {
        return new MappingContext((CharSequence)"/", (CharSequence)".");
    }

    @Bean
    ContentPropertyToRequestMappingContext exportedRequestMappingContext() {
        return new ContentPropertyToRequestMappingContext();
    }

    @Bean
    ContentPropertyToExportedContext exportedContentPropertyContext() {
        return new ContentPropertyToExportedContext();
    }

    @Bean
    ContentPropertyToLinkrelMappingContext linkrelMappingContext() {
        return new ContentPropertyToLinkrelMappingContext();
    }

    @Bean
    RequestMappingHandlerMapping contentHandlerMapping(Stores stores, EntityResolvers entityResolvers, ContentPropertyToRequestMappingContext exportedRequestMappingContext) {
        ContentHandlerMapping mapping = new ContentHandlerMapping(stores, entityResolvers, exportedRequestMappingContext, this);
        mapping.setCorsConfigurations(this.getCorsRegistry().getCorsConfigurations());
        mapping.setInterceptors(new Object[]{this.getStoreHandlerInterceptor()});
        return mapping;
    }

    @Bean
    StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler() {
        StoreByteRangeHttpRequestHandler handler = new StoreByteRangeHttpRequestHandler();
        handler.setUseLastModified(false);
        return handler;
    }

    @Bean
    EntityResolvers entityResolvers(ApplicationContext context, Stores stores, MappingContext mappingContext) {
        Repositories repositories;
        block2: {
            repositories = null;
            try {
                repositories = (Repositories)context.getBean(Repositories.class);
            }
            catch (NoSuchBeanDefinitionException nsbde) {
                if (repositories != null) break block2;
                repositories = new Repositories((ListableBeanFactory)context);
            }
        }
        EntityResolvers entityResolvers = new EntityResolvers();
        entityResolvers.add(new DefaultEntityResolver(context, repositories, stores, (ConversionService)this.converters(), "/{repository}/{id}", mappingContext));
        entityResolvers.add(new DefaultEntityResolver(context, repositories, stores, (ConversionService)this.converters(), "/{repository}/{id}/**", mappingContext));
        entityResolvers.add(new RevisionEntityResolver(repositories, stores, "/{repository}/{id}/revisions/{revisionId}", mappingContext));
        entityResolvers.add(new RevisionEntityResolver(repositories, stores, "/{repository}/{id}/revisions/{revisionId}/**", mappingContext));
        return entityResolvers;
    }

    public void afterPropertiesSet() throws Exception {
        for (ContentRestConfigurer configurer : this.configurers) {
            configurer.configure(this);
        }
        this.getStoreHandlerInterceptor().setBaseUri(this.baseUri);
    }

    public static class Exclusions
    extends HashMap<String, List<MediaType>> {
        private static final long serialVersionUID = 5499454344207867070L;

        public Exclusions exclude(String method, MediaType mediaType) {
            Assert.hasLength((String)method, (String)"method must not be null or empty");
            ArrayList<MediaType> excludes = (ArrayList<MediaType>)this.get(method);
            if (excludes == null) {
                excludes = new ArrayList<MediaType>();
                this.put(method, excludes);
            }
            excludes.add(mediaType);
            return this;
        }
    }

    public class DomainTypeConfig {
        private Resolver<Method, HttpHeaders> setContentResolver = new Resolver<Method, HttpHeaders>(){

            @Override
            public boolean resolve(Method method, HttpHeaders context) {
                return DomainTypeConfig.this.preferInputStream(method);
            }
        };

        public Resolver<Method, HttpHeaders> getSetContentResolver() {
            return this.setContentResolver;
        }

        public void setSetContentResolver(Resolver<Method, HttpHeaders> resolver) {
            this.setContentResolver = resolver;
        }

        public void putAndPostPreferResource() {
            this.setContentResolver = new Resolver<Method, HttpHeaders>(){

                @Override
                public boolean resolve(Method method, HttpHeaders context) {
                    return DomainTypeConfig.this.preferResource(method);
                }
            };
        }

        boolean preferResource(Method method) {
            for (Class<?> paramType : method.getParameterTypes()) {
                if (!Resource.class.equals(paramType)) continue;
                return true;
            }
            return false;
        }

        boolean preferInputStream(Method method) {
            for (Class<?> paramType : method.getParameterTypes()) {
                if (!InputStream.class.equals(paramType)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Resolver<S, C> {
        public boolean resolve(S var1, C var2);
    }

    @Configuration
    public static class WebConfig
    implements WebMvcConfigurer,
    InitializingBean {
        @Autowired
        private RestConfiguration config;
        @Autowired
        private ApplicationContext context;
        @Autowired(required=false)
        private Repositories repositories;
        @Autowired(required=false)
        private RepositoryInvokerFactory repoInvokerFactory;
        @Autowired
        private StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler;
        @Autowired
        private Stores stores;
        @Autowired
        private EntityResolvers entityResolvers;
        @Autowired
        private ContentPropertyToRequestMappingContext requestMappingContext;
        @Autowired
        private MappingContext mappingContext;

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            WebConfig.insertBeforeOrAppend(new ResourceHandlerMethodArgumentResolver(this.context, this.config, this.repositories, this.stores, this.requestMappingContext, this.mappingContext, this.entityResolvers), argumentResolvers, ProxyingHandlerMethodArgumentResolver.class);
        }

        public void afterPropertiesSet() throws Exception {
            if (this.repositories == null) {
                this.repositories = new Repositories((ListableBeanFactory)this.context);
            }
            if (this.repoInvokerFactory == null) {
                this.repoInvokerFactory = new DefaultRepositoryInvokerFactory(this.repositories);
            }
        }

        private static <T> void insertBeforeOrAppend(T elementToInsert, List<T> listToInsertInto, Class<? extends T> elementTypeToInsertBefore) {
            int index = -1;
            for (int i = 0; i < listToInsertInto.size(); ++i) {
                if (!elementTypeToInsertBefore.isInstance(listToInsertInto.get(i))) continue;
                index = i;
                break;
            }
            if (index != -1) {
                listToInsertInto.add(index, elementToInsert);
            } else {
                listToInsertInto.add(elementToInsert);
            }
        }
    }
}

