/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.apiee;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.phillipkruger.apiee.ApieeClasses;
import com.github.phillipkruger.apiee.CachedDocument;
import com.github.phillipkruger.apiee.SwaggerCache;
import com.github.phillipkruger.apiee.Templates;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/apiee/")
public class ApieeService {
    private static final Logger log = Logger.getLogger(ApieeService.class.getName());
    @Context
    private Application application;
    @Inject
    @ApieeClasses
    private Set<Class> apieeClasses;
    @Inject
    private SwaggerCache swaggerCache;
    @Inject
    private Templates templates;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpServletRequest request;
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String HTTP = "http";
    private static final String INDEX_HTML = "index.html";
    private static final String X_REQUEST_URI = "x-request-uri";
    private static final String X_FORWARDED_PORT = "x-forwarded-port";
    private static final String X_FORWARDED_PROTO = "x-forwarded-proto";
    private static final String X_FORWARDED_HOST = "x-forwarded-host";
    private static final String LOCALHOST = "localhost";
    private static final String X_CUSTOM_PORT = "x-custom-port";
    private static final String X_CUSTOM_PROTO = "x-custom-proto";
    private static final String X_CUSTOM_HOST = "x-custom-host";

    @GET
    @Produces(value={"image/png"})
    @Path(value="favicon-{size}.png")
    public byte[] getFavicon(@PathParam(value="size") int size) {
        return this.templates.getFavicon(size);
    }

    @GET
    @Produces(value={"image/png"})
    @Path(value="logo.png")
    public byte[] getLogo() {
        return this.templates.getOriginalLogo();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="index.html")
    public Response getSwaggerUI(@QueryParam(value="clearCache") @DefaultValue(value="false") boolean clearCache) {
        if (clearCache) {
            this.swaggerCache.clearCache();
        }
        String swaggerUI = this.templates.getSwaggerUIHtml(this.uriInfo, this.request);
        return Response.ok((Object)swaggerUI, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/css"})
    @Path(value="apiee.css")
    public Response getCss() {
        String css = this.templates.getStyle();
        return Response.ok((Object)css, (String)"text/css").build();
    }

    @GET
    @Produces(value={"text/html"})
    public Response getSwaggerUINaked() {
        URI fw = this.uriInfo.getRequestUriBuilder().path(INDEX_HTML).build(new Object[0]);
        return Response.temporaryRedirect((URI)fw).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="swagger.json")
    public String getSwaggerJson() {
        URL url = this.getOriginalRequestURL(this.request);
        if (url != null) {
            String json = this.swaggerCache.getSwaggerJson(this.getClasses(), url);
            return json;
        }
        return null;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="swagger.yaml")
    public String getSwaggerYaml() {
        URL url = this.getOriginalRequestURL(this.request);
        if (url != null) {
            return this.swaggerCache.getSwaggerYaml(this.getClasses(), url);
        }
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="generatedOn.json")
    public String getGeneratedOn() {
        Date date;
        URL url = this.getSwaggerJsonUrl(this.getOriginalRequestURL(this.request));
        if (url != null && (date = this.swaggerCache.getGeneratedDate(url)) != null) {
            return this.toJson(date);
        }
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="cacheMap.json")
    public String getCacheMap() {
        Map<Integer, CachedDocument> swaggerMap = this.swaggerCache.getSwaggerMap();
        return this.toJson(swaggerMap);
    }

    @DELETE
    public void clearCache() {
        this.swaggerCache.clearCache();
    }

    private Set<Class<?>> getClasses() {
        Set classes = this.application.getClasses();
        if (classes != null && !classes.isEmpty()) {
            return classes;
        }
        HashSet applicationClasses = new HashSet();
        this.apieeClasses.forEach(c -> applicationClasses.add((Class<?>)c));
        return applicationClasses;
    }

    private URL getOriginalRequestURL(HttpServletRequest request) {
        try {
            String path = this.getOriginalPath(request);
            String scheme = this.getOriginalRequestScheme(request);
            String host = this.getOriginalRequestHost(request);
            int port = this.getOriginalRequestPort(request, scheme);
            URL u = new URL(scheme, host, port, path);
            return u;
        }
        catch (MalformedURLException ex) {
            log.warning("Could not determine URL for swagger.json");
            return null;
        }
    }

    private int getOriginalRequestPort(HttpServletRequest request, String scheme) {
        int portFromHeader = request.getIntHeader(X_CUSTOM_PORT);
        if (portFromHeader != -1 && portFromHeader > 0) {
            return portFromHeader;
        }
        portFromHeader = request.getIntHeader(X_FORWARDED_PORT);
        if (portFromHeader != -1 && portFromHeader > 0 && portFromHeader != 80 && portFromHeader != 443) {
            return portFromHeader;
        }
        int original = request.getServerPort();
        if (original != -1 && original > 0 && original != 80 && original != 443) {
            return original;
        }
        try {
            int portFromUrl = new URL(request.getRequestURL().toString()).getPort();
            if (portFromUrl != -1 && portFromUrl > 0 && portFromUrl != 80 && portFromUrl != 443) {
                return portFromUrl;
            }
            return this.getDefaultPort(scheme);
        }
        catch (MalformedURLException ex) {
            log.log(Level.WARNING, "Can not determine URL port - {0}", ex.getMessage());
            return this.getDefaultPort(scheme);
        }
    }

    private int getDefaultPort(String scheme) {
        if (scheme == null || scheme.isEmpty() || scheme.equalsIgnoreCase(HTTP)) {
            return 80;
        }
        return 443;
    }

    private String getOriginalRequestHost(HttpServletRequest request) {
        String original = request.getHeader(X_CUSTOM_HOST);
        if (original != null && !original.isEmpty()) {
            return original;
        }
        original = request.getHeader(X_FORWARDED_HOST);
        if (original != null && !original.isEmpty()) {
            return original;
        }
        original = request.getServerName();
        if (original != null && !original.isEmpty()) {
            return original;
        }
        try {
            return new URL(request.getRequestURL().toString()).getHost();
        }
        catch (MalformedURLException ex) {
            log.log(Level.WARNING, "Can not determine URL host - {0}", ex.getMessage());
            return LOCALHOST;
        }
    }

    private String getOriginalRequestScheme(HttpServletRequest request) {
        String original = request.getHeader(X_CUSTOM_PROTO);
        if (original != null && !original.isEmpty()) {
            return original;
        }
        original = request.getHeader(X_FORWARDED_PROTO);
        if (original != null && !original.isEmpty()) {
            return original;
        }
        try {
            return new URL(request.getRequestURL().toString()).getProtocol();
        }
        catch (MalformedURLException ex) {
            log.log(Level.WARNING, "Can not determine URL scheme - {0}", ex.getMessage());
            return HTTP;
        }
    }

    private String getOriginalPath(HttpServletRequest request) {
        String original = request.getHeader(X_REQUEST_URI);
        if (original != null && !original.isEmpty()) {
            return original;
        }
        return request.getRequestURI();
    }

    private String toJson(Map<Integer, CachedDocument> cache) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        Collection<CachedDocument> cachedDocuments = cache.values();
        for (CachedDocument cachedDocument : cachedDocuments) {
            ObjectNode objectNode = mapper.createObjectNode();
            objectNode.put("hash", cachedDocument.getHash());
            objectNode.put("generatedOn", cachedDocument.getGeneratedOn().toString());
            objectNode.put("url", cachedDocument.getUrl().toExternalForm());
            arrayNode.add((JsonNode)objectNode);
        }
        return arrayNode.toString();
    }

    private String toJson(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode objectNode = mapper.createObjectNode();
        objectNode.put("date", date.toString());
        objectNode.put("formattedDate", sdf.format(date));
        return objectNode.toString();
    }

    private URL getSwaggerJsonUrl(URL sibling) {
        try {
            return new URL(sibling, "swagger.json");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

