/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.apiee;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.phillipkruger.apiee.CachedDocument;
import com.github.phillipkruger.apiee.WhiteLabel;
import io.swagger.jaxrs.Reader;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;

@ApplicationScoped
public class SwaggerCache {
    private static final Logger log = Logger.getLogger(SwaggerCache.class.getName());
    private final Map<Integer, CachedDocument> swaggerMap = new ConcurrentHashMap<Integer, CachedDocument>();
    @Inject
    private WhiteLabel whiteLabel;
    private static final String APIEE_CONTEXT = "/apiee/";
    private static final String DOUBLE_POINT = ":";
    private static final String SLASH = "/";
    private static final String COMMA = ",";
    private static final String INFO_TITLE = "infoTitle";
    private static final String INFO_DESC = "infoDescription";
    private static final String INFO_VERSION = "infoVersion";
    private static final String INFO_TERMS = "infoTermsOfService";
    private static final String INFO_CONTACT_NAME = "infoContactName";
    private static final String INFO_CONTACT_EMAIL = "infoContactEmail";
    private static final String INFO_CONTACT_URL = "infoContactUrl";
    private static final String INFO_LICENSE_NAME = "infoLicenseName";
    private static final String INFO_LICENSE_URL = "infoLicenseUrl";
    private static final String CONSUMES = "consumes";
    private static final String PRODUCES = "produces";
    private static final String BASE_PATH = "basePath";
    private static final String SCHEMES = "schemes";
    private static final String HOST = "host";
    private static final String TAGS = "tags";
    private static final String BASIC_AUTH_KEY = "securityBasicAuthKey";
    private static final String BASIC_AUTH_DESC = "securityBasicAuthDesc";
    private static final String API_KEY_KEY = "securityApiKeyKey";
    private static final String API_KEY_IN = "securityApiKeyIn";
    private static final String API_KEY_DESC = "securityApiKeyDesc";
    private static final String API_KEY_NAME = "securityApiKeyName";
    private static final String OAUTH2_KEY = "securityOAuth2Key";
    private static final String OAUTH2_AUTH_URL = "securityOAuth2AuthUrl";
    private static final String OAUTH2_TOKEN_URL = "securityOAuth2TokenUrl";
    private static final String OAUTH2_FLOW = "securityOAuth2Flow";
    private static final String OAUTH2_SCOPES = "securityOAuth2Scopes";
    private static final String OAUTH2_DESC = "securityOAuth2Desc";

    public String getSwaggerJson(Set<Class<?>> classes, @NotNull URL url) {
        int hash = url.toExternalForm().hashCode();
        if (this.swaggerMap.containsKey(hash)) {
            log.log(Level.FINEST, "Loading {0} from cache", url);
            return this.swaggerMap.get(hash).getDocument();
        }
        return this.generateJson(hash, classes, url);
    }

    public String getSwaggerYaml(Set<Class<?>> classes, @NotNull URL url) {
        int hash = url.toExternalForm().hashCode();
        if (this.swaggerMap.containsKey(hash)) {
            log.log(Level.FINEST, "Loading {0} from cache", url);
            return this.swaggerMap.get(hash).getDocument();
        }
        return this.generateYaml(hash, classes, url);
    }

    public Date getGeneratedDate(@NotNull URL url) {
        int hash = url.toExternalForm().hashCode();
        if (this.swaggerMap.containsKey(hash)) {
            return this.swaggerMap.get(hash).getGeneratedOn();
        }
        return null;
    }

    public void clearCache() {
        log.info("Clearing Apiee cache...");
        this.swaggerMap.clear();
    }

    private String generateJson(int hash, Set<Class<?>> classes, URL url) {
        log.log(Level.FINEST, "Generating {0} response from context", url);
        Swagger swagger = this.createSwagger(classes, url);
        try {
            String swaggerJson = Json.pretty().writeValueAsString((Object)swagger);
            this.swaggerMap.put(hash, new CachedDocument(hash, url, swaggerJson));
            return swaggerJson;
        }
        catch (JsonProcessingException ex) {
            log.log(Level.WARNING, "Could not generate {0} - {1}", new Object[]{url.toString(), ex.getMessage()});
            log.log(Level.WARNING, "Could not generate {0} - null", new Object[]{url.toString()});
            return null;
        }
    }

    private String generateYaml(int hash, Set<Class<?>> classes, URL url) {
        log.log(Level.FINEST, "Generating {0} response for context", url);
        Swagger swagger = this.createSwagger(classes, url);
        try {
            String swaggerYaml = Yaml.pretty().writeValueAsString((Object)swagger);
            this.swaggerMap.put(hash, new CachedDocument(hash, url, swaggerYaml));
            return swaggerYaml;
        }
        catch (JsonProcessingException ex) {
            log.log(Level.WARNING, "Could not generate {0} - {1}", new Object[]{url.toString(), ex.getMessage()});
            log.log(Level.WARNING, "Could not generate {0} - null", new Object[]{url.toString()});
            return null;
        }
    }

    private Swagger createSwagger(Set<Class<?>> classes, URL url) {
        Map<String, SecuritySchemeDefinition> securityDefinitions;
        Swagger swagger = new Reader(new Swagger()).read(classes);
        Info info = this.getSwaggerInfo(swagger);
        if (info != null) {
            swagger.setInfo(info);
        }
        if ((securityDefinitions = this.getSecurityDefinitions(swagger)) != null) {
            swagger.setSecurityDefinitions(securityDefinitions);
        }
        String consumes = this.whiteLabel.getProperty(CONSUMES, null);
        if (this.anyIsSet(consumes)) {
            swagger.setConsumes(this.toList(swagger.getConsumes(), consumes));
        }
        String produces = this.whiteLabel.getProperty(PRODUCES, null);
        if (this.anyIsSet(produces)) {
            swagger.setProduces(this.toList(swagger.getProduces(), produces));
        }
        String basePath = this.whiteLabel.getProperty(BASE_PATH, this.getBasePath(swagger.getBasePath(), url));
        if (this.anyIsSet(basePath)) {
            swagger.setBasePath(basePath);
        }
        String schemes = this.whiteLabel.getProperty(SCHEMES, url.getProtocol().toUpperCase());
        if (this.anyIsSet(schemes)) {
            swagger.setSchemes(this.toSchemeList(swagger.getSchemes(), schemes));
        }
        String host = this.whiteLabel.getProperty(HOST, url.getHost() + DOUBLE_POINT + url.getPort());
        if (this.anyIsSet(host)) {
            swagger.setHost(host);
        }
        String tags = this.whiteLabel.getProperty(TAGS, null);
        if (this.anyIsSet(tags)) {
            swagger.setTags(this.toTagList(swagger.getTags(), tags));
        }
        return swagger;
    }

    private List<String> toList(List<String> original, String newCommaSeperated) {
        if (original != null) {
            original.addAll(this.toList(newCommaSeperated));
        } else {
            original = this.toList(newCommaSeperated);
        }
        return original;
    }

    private List<Scheme> toSchemeList(List<Scheme> original, String schemes) {
        ArrayList<Scheme> schemeList = new ArrayList<Scheme>();
        this.toList(schemes).forEach(scheme -> schemeList.add(Scheme.forValue((String)scheme)));
        if (original != null) {
            original.addAll(schemeList);
            return original;
        }
        return schemeList;
    }

    private List<Tag> toTagList(List<Tag> original, String tags) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (String tag : this.toList(tags)) {
            Tag t = new Tag();
            if (tag.contains(DOUBLE_POINT)) {
                String[] nameAndDesc = tag.split(DOUBLE_POINT);
                t.setName(nameAndDesc[0]);
                t.setDescription(nameAndDesc[1]);
            } else {
                t.setName(tag);
            }
            tagList.add(t);
        }
        if (original != null) {
            original.addAll(tagList);
            return original;
        }
        return tagList;
    }

    private List<String> toList(String s) {
        return Arrays.asList(s.split(COMMA));
    }

    private String getBasePath(String existingBasePath, URL url) {
        String path = url.getPath();
        if (existingBasePath != null && !existingBasePath.isEmpty()) {
            int i = path.indexOf(existingBasePath + SLASH);
            return path.substring(0, i) + existingBasePath;
        }
        int i = path.indexOf(APIEE_CONTEXT);
        return path.substring(0, i);
    }

    private Map<String, SecuritySchemeDefinition> getSecurityDefinitions(Swagger swagger) {
        String oauth2Key;
        String apiKeyKey;
        String basicAuthKey;
        HashMap<String, SecuritySchemeDefinition> securityDefinitions = swagger.getSecurityDefinitions();
        if (securityDefinitions == null) {
            securityDefinitions = new HashMap<String, SecuritySchemeDefinition>();
        }
        if ((basicAuthKey = this.whiteLabel.getProperty(BASIC_AUTH_KEY, null)) != null && !basicAuthKey.isEmpty()) {
            BasicAuthDefinition basicAuthDefinition = new BasicAuthDefinition();
            String basicAuthDescription = this.whiteLabel.getProperty(BASIC_AUTH_DESC, null);
            if (this.allIsSet(basicAuthDescription)) {
                basicAuthDefinition.setDescription(basicAuthDescription);
            }
            securityDefinitions.put(basicAuthKey, (SecuritySchemeDefinition)basicAuthDefinition);
        }
        if ((apiKeyKey = this.whiteLabel.getProperty(API_KEY_KEY, null)) != null && !apiKeyKey.isEmpty()) {
            String apiKeyName;
            String apiKeyDescription;
            ApiKeyAuthDefinition apiKeyAuthDefinition = new ApiKeyAuthDefinition();
            String apiKeyIn = this.whiteLabel.getProperty(API_KEY_IN, "HEADER");
            if (this.allIsSet(apiKeyIn)) {
                apiKeyAuthDefinition.setIn(In.forValue((String)apiKeyIn));
            }
            if (this.allIsSet(apiKeyDescription = this.whiteLabel.getProperty(API_KEY_DESC, null))) {
                apiKeyAuthDefinition.setDescription(apiKeyDescription);
            }
            if (this.allIsSet(apiKeyName = this.whiteLabel.getProperty(API_KEY_NAME, "Authorization"))) {
                apiKeyAuthDefinition.setName(apiKeyName);
            }
            securityDefinitions.put(apiKeyKey, (SecuritySchemeDefinition)apiKeyAuthDefinition);
        }
        if ((oauth2Key = this.whiteLabel.getProperty(OAUTH2_KEY, null)) != null && !oauth2Key.isEmpty()) {
            String oauth2Scopes;
            String oauth2Flow;
            String oauth2Description;
            String tokenUrl;
            OAuth2Definition oAuth2Definition = new OAuth2Definition();
            String authorizationUrl = this.whiteLabel.getProperty(OAUTH2_AUTH_URL, null);
            if (this.allIsSet(authorizationUrl)) {
                oAuth2Definition.setAuthorizationUrl(authorizationUrl);
            }
            if (this.allIsSet(tokenUrl = this.whiteLabel.getProperty(OAUTH2_TOKEN_URL, null))) {
                oAuth2Definition.setTokenUrl(tokenUrl);
            }
            if (this.allIsSet(oauth2Description = this.whiteLabel.getProperty(OAUTH2_DESC, null))) {
                oAuth2Definition.setDescription(oauth2Description);
            }
            if (this.allIsSet(oauth2Flow = this.whiteLabel.getProperty(OAUTH2_FLOW, null))) {
                oAuth2Definition.setFlow(oauth2Flow);
            }
            if (this.allIsSet(oauth2Scopes = this.whiteLabel.getProperty(OAUTH2_SCOPES, null))) {
                oAuth2Definition.setScopes(this.toScopesMaps(oauth2Scopes));
            }
            securityDefinitions.put(oauth2Key, (SecuritySchemeDefinition)oAuth2Definition);
        }
        return securityDefinitions;
    }

    private Map<String, String> toScopesMaps(String line) {
        String[] scopes;
        HashMap<String, String> m = new HashMap<String, String>();
        for (String scope : scopes = line.split(COMMA)) {
            String[] kv = scope.split(DOUBLE_POINT);
            m.put(kv[0], kv[1]);
        }
        return m;
    }

    private Info getSwaggerInfo(Swagger swagger) {
        String terms;
        String version;
        String description;
        Info info = swagger.getInfo();
        if (info == null) {
            info = new Info();
        }
        Contact contact = this.getSwaggerContact();
        License license = this.getSwaggerLicense();
        String title = this.whiteLabel.getProperty(INFO_TITLE, null);
        if (this.anyIsSet(title, description = this.whiteLabel.getProperty(INFO_DESC, null), version = this.whiteLabel.getProperty(INFO_VERSION, null), terms = this.whiteLabel.getProperty(INFO_TERMS, null)) || contact != null || license != null) {
            if (this.anyIsSet(title)) {
                info.setTitle(title);
            }
            if (this.anyIsSet(description)) {
                info.setDescription(description);
            }
            if (this.anyIsSet(version)) {
                info.setVersion(version);
            }
            if (this.anyIsSet(terms)) {
                info.setTermsOfService(terms);
            }
            if (contact != null) {
                info.setContact(contact);
            }
            if (license != null) {
                info.setLicense(license);
            }
            return info;
        }
        return null;
    }

    private Contact getSwaggerContact() {
        String name = this.whiteLabel.getProperty(INFO_CONTACT_NAME, null);
        String email = this.whiteLabel.getProperty(INFO_CONTACT_EMAIL, null);
        String url = this.whiteLabel.getProperty(INFO_CONTACT_URL, null);
        if (this.anyIsSet(name, email, url)) {
            Contact contact = new Contact();
            if (this.anyIsSet(email)) {
                contact.setEmail(email);
            }
            if (this.anyIsSet(name)) {
                contact.setName(name);
            }
            if (this.anyIsSet(url)) {
                contact.setUrl(url);
            }
            return contact;
        }
        return null;
    }

    private License getSwaggerLicense() {
        String name = this.whiteLabel.getProperty(INFO_LICENSE_NAME, null);
        String url = this.whiteLabel.getProperty(INFO_LICENSE_URL, null);
        if (this.anyIsSet(name, url)) {
            License license = new License();
            if (this.anyIsSet(name)) {
                license.setName(name);
            }
            if (this.anyIsSet(url)) {
                license.setUrl(url);
            }
            return license;
        }
        return null;
    }

    private boolean anyIsSet(String ... value) {
        for (String v : value) {
            if (v == null || v.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean allIsSet(String ... value) {
        for (String v : value) {
            if (v != null && !v.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Map<Integer, CachedDocument> getSwaggerMap() {
        return this.swaggerMap;
    }
}

