/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.apiee;

import com.github.phillipkruger.apiee.WhiteLabel;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;

@ApplicationScoped
public class Templates {
    private static final Logger log = Logger.getLogger(Templates.class.getName());
    private byte[] originalLogo = null;
    private byte[] favicon32 = null;
    private byte[] favicon16 = null;
    private String style = null;
    @Inject
    private WhiteLabel whiteLabel;
    private String swaggerUIHtml = null;
    private static final String X_REQUEST_URI = "x-request-uri";
    private static final String VAR_CONTEXT_ROOT = "%contextRoot%";
    private static final String VAR_CURRENT_YEAR = "%currentYear%";
    private static final String VAR_COPYRIGHT_BY = "%copyrighBy%";
    private static final String VAL_COPYRIGHT_BY = "Phillip Kruger";
    private static final String VAR_TITLE = "%title%";
    private static final String VAL_TITLE = "Apiee - Swagger for Java EE";
    private static final String VAR_JSON_BUTTON = "%jsonButtonCaption%";
    private static final String VAL_JSON_BUTTON = "json";
    private static final String VAR_YAML_BUTTON = "%yamlButtonCaption%";
    private static final String VAL_YAML_BUTTON = "yaml";
    private static final String VAR_SWAGGER_THEME = "%swaggerUiTheme%";
    private static final String VAL_SWAGGER_THEME = "muted";
    private static final String VAR_DOC_EXPANSION = "%docExpansion%";
    private static final String VAL_DOC_EXPANSION = "none";
    private static final String VAR_JSON_EDITOR = "%jsonEditor%";
    private static final String VAL_JSON_EDITOR = "true";
    private static final String VAR_DEFAULT_MODEL_RENDERING = "%defaultModelRendering%";
    private static final String VAL_DEFAULT_MODEL_RENDERING = "schema";
    private static final String VAR_SHOW_REQUEST_HEADERS = "%showRequestHeaders%";
    private static final String VAL_SHOW_REQUEST_HEADERS = "true";
    private static final String VAR_SHOW_OPERATION_IDS = "%showOperationIds%";
    private static final String VAL_SHOW_OPERATION_IDS = "false";
    private static final String VAR_VALIDATOR_URL = "%validatorUrl%";
    private static final String VAL_VALIDATOR_URL = "null";
    private static final String VAR_SUPPORTED_SUBMIT_METHODS = "%supportedSubmitMethods%";
    private static final String VAL_SUPPORTED_SUBMIT_METHODS = "['get', 'post', 'put', 'delete']";
    private static final String VAR_OAUTH_CLIENT_ID = "%oauthClientId%";
    private static final String VAL_OAUTH_CLIENT_ID = "your-client-id";
    private static final String VAR_OAUTH_CLIENT_SECRET = "%oauthClientSecret%";
    private static final String VAL_OAUTH_CLIENT_SECRET = "your-client-secret-if-required";
    private static final String VAR_OAUTH_REALM = "%oauthRealm%";
    private static final String VAL_OAUTH_REALM = "your-realms";
    private static final String VAR_OAUTH_APP_NAME = "%oauthAppName%";
    private static final String VAL_OAUTH_APP_NAME = "your-app-name";
    private static final String VAR_OAUTH_SCOPE_SEPARATOR = "%oauthScopeSeparator%";
    private static final String VAL_OAUTH_SCOPE_SEPARATOR = " ";
    private static final String VAR_SERVER_INFO = "%serverInfo%";
    private static final String PERSENTAGE = "%";
    private static final String PNG = "png";
    private static final String NL = "\n";
    private static final String EMPTY = "";
    private static final String FILE_TEMPLATE = "META-INF/resources/apiee/template.html";
    private static final String FILE_LOGO = "META-INF/resources/apiee/logo.png";
    private static final String FILE_STYLE = "META-INF/resources/apiee/style.css";

    @PostConstruct
    public void afterCreate() {
        BufferedImage image = this.getLogo();
        BufferedImage image16 = this.getFavicon(16, image);
        BufferedImage image32 = this.getFavicon(32, image);
        try {
            this.originalLogo = this.toBytes(image);
            log.finest("Apiee UI: Created logo");
            this.favicon16 = this.toBytes(image16);
            this.favicon32 = this.toBytes(image32);
            log.finest("Apiee UI: Created favicons");
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        this.style = this.getCss();
    }

    public String getSwaggerUIHtml(UriInfo uriInfo, HttpServletRequest request) {
        if (this.swaggerUIHtml == null) {
            this.swaggerUIHtml = this.parseHtmlTemplate(uriInfo, request);
        }
        return this.swaggerUIHtml;
    }

    public byte[] getFavicon(int size) {
        if (size > 24) {
            return this.getFavicon32();
        }
        return this.getFavicon16();
    }

    private String parseHtmlTemplate(UriInfo uriInfo, HttpServletRequest request) {
        String html = this.getHTMLTemplate();
        html = html.replaceAll(VAR_CONTEXT_ROOT, this.getOriginalContextPath(uriInfo, request));
        html = html.replaceAll(VAR_CURRENT_YEAR, String.valueOf(Calendar.getInstance().get(1)));
        if (this.whiteLabel.hasProperties()) {
            Map<String, String> properties = this.whiteLabel.getProperties();
            Set<Map.Entry<String, String>> pes = properties.entrySet();
            for (Map.Entry<String, String> p : pes) {
                String key = PERSENTAGE + p.getKey() + PERSENTAGE;
                html = html.replaceAll(key, p.getValue());
            }
        } else {
            log.warning("No white label properties, returning vanilla template");
        }
        html = html.replaceAll(VAR_COPYRIGHT_BY, VAL_COPYRIGHT_BY);
        html = html.replaceAll(VAR_TITLE, VAL_TITLE);
        html = html.replaceAll(VAR_JSON_BUTTON, VAL_JSON_BUTTON);
        html = html.replaceAll(VAR_YAML_BUTTON, VAL_YAML_BUTTON);
        html = html.replaceAll(VAR_SWAGGER_THEME, VAL_SWAGGER_THEME);
        html = html.replaceAll(VAR_DOC_EXPANSION, VAL_DOC_EXPANSION);
        html = html.replaceAll(VAR_JSON_EDITOR, "true");
        html = html.replaceAll(VAR_DEFAULT_MODEL_RENDERING, VAL_DEFAULT_MODEL_RENDERING);
        html = html.replaceAll(VAR_SHOW_REQUEST_HEADERS, "true");
        html = html.replaceAll(VAR_SHOW_OPERATION_IDS, VAL_SHOW_OPERATION_IDS);
        html = html.replaceAll(VAR_VALIDATOR_URL, VAL_VALIDATOR_URL);
        html = html.replaceAll(VAR_SUPPORTED_SUBMIT_METHODS, VAL_SUPPORTED_SUBMIT_METHODS);
        html = html.replaceAll(VAR_OAUTH_CLIENT_ID, VAL_OAUTH_CLIENT_ID);
        html = html.replaceAll(VAR_OAUTH_CLIENT_SECRET, VAL_OAUTH_CLIENT_SECRET);
        html = html.replaceAll(VAR_OAUTH_REALM, VAL_OAUTH_REALM);
        html = html.replaceAll(VAR_OAUTH_APP_NAME, VAL_OAUTH_APP_NAME);
        html = html.replaceAll(VAR_OAUTH_SCOPE_SEPARATOR, VAL_OAUTH_SCOPE_SEPARATOR);
        html = html.replaceAll(VAR_SERVER_INFO, request.getServletContext().getServerInfo());
        return html;
    }

    private String getOriginalContextPath(UriInfo uriInfo, HttpServletRequest request) {
        String fromHeader = request.getHeader(X_REQUEST_URI);
        if (fromHeader != null && !fromHeader.isEmpty()) {
            return this.getContextPathPart(uriInfo, request, fromHeader);
        }
        return request.getContextPath();
    }

    private String getContextPathPart(UriInfo uriInfo, HttpServletRequest request, String fromHeader) {
        String restBase = request.getServletPath();
        String restUrl = restBase + uriInfo.getPath();
        int restUrlStart = fromHeader.indexOf(restUrl);
        if (restUrlStart > 0) {
            return fromHeader.substring(0, restUrlStart);
        }
        return fromHeader;
    }

    private String toString(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
            String string = buffer.lines().collect(Collectors.joining(NL));
            return string;
        }
    }

    private BufferedImage getLogo() {
        BufferedImage bufferedImage;
        block9: {
            if (this.whiteLabel.hasLogo()) {
                return this.whiteLabel.getLogo();
            }
            InputStream logo = this.getClass().getClassLoader().getResourceAsStream(FILE_LOGO);
            try {
                bufferedImage = ImageIO.read(logo);
                if (logo == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (logo != null) {
                        try {
                            logo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return null;
                }
            }
            logo.close();
        }
        return bufferedImage;
    }

    private String getCss() {
        String string;
        block9: {
            if (this.whiteLabel.hasCss()) {
                return this.whiteLabel.getCss();
            }
            InputStream css = this.getClass().getClassLoader().getResourceAsStream(FILE_STYLE);
            try {
                string = this.toString(css);
                if (css == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (css != null) {
                        try {
                            css.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return EMPTY;
                }
            }
            css.close();
        }
        return string;
    }

    private String getHTMLTemplate() {
        String string;
        block9: {
            if (this.whiteLabel.hasHtml()) {
                return this.whiteLabel.getHtml();
            }
            InputStream template = this.getClass().getClassLoader().getResourceAsStream(FILE_TEMPLATE);
            try {
                string = this.toString(template);
                if (template == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return EMPTY;
                }
            }
            template.close();
        }
        return string;
    }

    private BufferedImage getFavicon(int size, BufferedImage original) {
        int type = original.getType() == 0 ? 2 : original.getType();
        return this.resizeImage(size, original, type);
    }

    private BufferedImage resizeImage(int size, BufferedImage originalImage, int type) {
        BufferedImage resizedImage = new BufferedImage(size, size, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, size, size, null);
        g.dispose();
        return resizedImage;
    }

    private byte[] toBytes(BufferedImage bufferedImage) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufferedImage, PNG, baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public byte[] getOriginalLogo() {
        return this.originalLogo;
    }

    public byte[] getFavicon32() {
        return this.favicon32;
    }

    public byte[] getFavicon16() {
        return this.favicon16;
    }

    public String getStyle() {
        return this.style;
    }
}

