/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx;

import com.github.pjfanning.xlsx.impl.StreamingWorkbook;
import com.github.pjfanning.xlsx.impl.StreamingWorkbookReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Workbook;

public class StreamingReader
implements AutoCloseable {
    private final StreamingWorkbookReader workbook;

    public StreamingReader(StreamingWorkbookReader workbook) {
        this.workbook = workbook;
    }

    @Override
    public void close() throws IOException {
        this.workbook.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int rowCacheSize = 10;
        private int bufferSize = 1024;
        private boolean avoidTempFiles = false;
        private boolean useSstTempFile = false;
        private boolean encryptSstTempFile = false;
        private boolean adjustLegacyComments = false;
        private boolean readComments = false;
        private boolean readCoreProperties = false;
        private boolean readHyperlinks = false;
        private boolean readShapes = false;
        private String password;
        private boolean convertFromOoXmlStrict;

        public int getRowCacheSize() {
            return this.rowCacheSize;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean avoidTempFiles() {
            return this.avoidTempFiles;
        }

        public boolean useSstTempFile() {
            return this.useSstTempFile;
        }

        public boolean encryptSstTempFile() {
            return this.encryptSstTempFile;
        }

        public boolean adjustLegacyComments() {
            return this.adjustLegacyComments;
        }

        public boolean readComments() {
            return this.readComments;
        }

        public boolean readCoreProperties() {
            return this.readCoreProperties;
        }

        public boolean readHyperlinks() {
            return this.readHyperlinks;
        }

        public boolean readShapes() {
            return this.readShapes;
        }

        public boolean convertFromOoXmlStrict() {
            return this.convertFromOoXmlStrict;
        }

        public Builder rowCacheSize(int rowCacheSize) {
            this.rowCacheSize = rowCacheSize;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Deprecated
        public Builder convertFromOoXmlStrict(boolean convertFromOoXmlStrict) {
            this.convertFromOoXmlStrict = convertFromOoXmlStrict;
            return this;
        }

        public Builder setAvoidTempFiles(boolean avoidTempFiles) {
            this.avoidTempFiles = avoidTempFiles;
            return this;
        }

        public Builder setUseSstTempFile(boolean useSstTempFile) {
            this.useSstTempFile = useSstTempFile;
            return this;
        }

        public Builder setEncryptSstTempFile(boolean encryptSstTempFile) {
            this.encryptSstTempFile = encryptSstTempFile;
            return this;
        }

        public Builder setReadComments(boolean readComments) {
            this.readComments = readComments;
            return this;
        }

        public Builder setAdjustLegacyComments(boolean adjustLegacyComments) {
            this.adjustLegacyComments = adjustLegacyComments;
            return this;
        }

        public Builder setReadCoreProperties(boolean readCoreProperties) {
            this.readCoreProperties = readCoreProperties;
            return this;
        }

        public Builder setReadHyperlinks(boolean readHyperlinks) {
            this.readHyperlinks = readHyperlinks;
            return this;
        }

        public Builder setReadShapes(boolean readShapes) {
            this.readShapes = readShapes;
            return this;
        }

        public Workbook open(InputStream is) {
            StreamingWorkbookReader workbook = new StreamingWorkbookReader(this);
            workbook.init(is);
            return new StreamingWorkbook(workbook);
        }

        public Workbook open(File file) {
            StreamingWorkbookReader workbook = new StreamingWorkbookReader(this);
            workbook.init(file);
            return new StreamingWorkbook(workbook);
        }
    }
}

