/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.xlsx.XmlUtils;
import com.github.pjfanning.xlsx.exceptions.NotSupportedException;
import com.github.pjfanning.xlsx.impl.DateTimeUtil;
import com.github.pjfanning.xlsx.impl.Supplier;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class StreamingCell
implements Cell {
    private static final Supplier NULL_SUPPLIER = () -> null;
    private final Sheet sheet;
    private final int columnIndex;
    private int rowIndex;
    private Row row;
    private final boolean use1904Dates;
    private Supplier contentsSupplier = NULL_SUPPLIER;
    private String rawContents;
    private String formula;
    private String numericFormat;
    private Short numericFormatIndex;
    private String type;
    private CellStyle cellStyle;
    private boolean formulaType;

    public StreamingCell(Sheet sheet, int columnIndex, int rowIndex, boolean use1904Dates) {
        this.sheet = sheet;
        this.columnIndex = columnIndex;
        this.rowIndex = rowIndex;
        this.use1904Dates = use1904Dates;
    }

    public StreamingCell(Sheet sheet, int columnIndex, Row row, boolean use1904Dates) {
        this.sheet = sheet;
        this.columnIndex = columnIndex;
        this.row = row;
        this.use1904Dates = use1904Dates;
    }

    public void setContentSupplier(Supplier contentsSupplier) {
        this.contentsSupplier = contentsSupplier;
    }

    public void setRawContents(String rawContents) {
        this.rawContents = rawContents;
    }

    public String getNumericFormat() {
        return this.numericFormat;
    }

    public void setNumericFormat(String numericFormat) {
        this.numericFormat = numericFormat;
    }

    public Short getNumericFormatIndex() {
        return this.numericFormatIndex;
    }

    public void setNumericFormatIndex(Short numericFormatIndex) {
        this.numericFormatIndex = numericFormatIndex;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isFormulaType() {
        return this.formulaType;
    }

    public void setFormulaType(boolean formulaType) {
        this.formulaType = formulaType;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.row == null ? this.rowIndex : this.row.getRowNum();
    }

    public Row getRow() {
        return this.row;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public CellType getCellType() {
        if (this.formulaType) {
            return CellType.FORMULA;
        }
        if (this.contentsSupplier.getContent() == null || this.type == null) {
            return CellType.BLANK;
        }
        if ("n".equals(this.type)) {
            return CellType.NUMERIC;
        }
        if ("d".equals(this.type)) {
            return CellType.NUMERIC;
        }
        if ("s".equals(this.type) || "inlineStr".equals(this.type) || "str".equals(this.type)) {
            return CellType.STRING;
        }
        if ("b".equals(this.type)) {
            return CellType.BOOLEAN;
        }
        if ("e".equals(this.type)) {
            return CellType.ERROR;
        }
        throw new UnsupportedOperationException("Unsupported cell type '" + this.type + "'");
    }

    public String getStringCellValue() {
        Object c = this.contentsSupplier.getContent();
        return c == null ? "" : c.toString();
    }

    public double getNumericCellValue() {
        if ("d".equals(this.type)) {
            try {
                LocalDateTime dt = DateTimeUtil.parseDateTime(this.rawContents);
                return DateUtil.getExcelDate((LocalDateTime)dt, (boolean)this.use1904Dates);
            }
            catch (Exception e) {
                try {
                    return DateTimeUtil.convertTime(this.rawContents);
                }
                catch (Exception e2) {
                    throw new IllegalStateException("cannot parse strict format date/time " + this.rawContents);
                }
            }
        }
        return this.rawContents == null ? 0.0 : Double.parseDouble(this.rawContents);
    }

    public Date getDateCellValue() {
        if (this.getCellType() == CellType.STRING) {
            throw new IllegalStateException("Cell type cannot be CELL_TYPE_STRING");
        }
        return this.rawContents == null ? null : DateUtil.getJavaDate((double)this.getNumericCellValue(), (boolean)this.use1904Dates);
    }

    public boolean getBooleanCellValue() {
        CellType cellType = this.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = this.getCachedFormulaResultType();
        }
        switch (cellType) {
            case BLANK: {
                return false;
            }
            case BOOLEAN: {
                return this.rawContents != null && XmlUtils.evaluateBoolean(this.rawContents);
            }
        }
        throw StreamingCell.typeMismatch(CellType.BOOLEAN, cellType, this.isFormulaType());
    }

    private static IllegalStateException typeMismatch(CellType expectedType, CellType actualType, boolean isFormulaCell) {
        String msg = "Cannot get a " + StreamingCell.getCellTypeName(expectedType) + " value from a " + StreamingCell.getCellTypeName(actualType) + " " + (isFormulaCell ? "formula " : "") + "cell";
        return new IllegalStateException(msg);
    }

    private static String getCellTypeName(CellType cellType) {
        switch (cellType) {
            case BLANK: {
                return "blank";
            }
            case STRING: {
                return "text";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case ERROR: {
                return "error";
            }
            case NUMERIC: {
                return "numeric";
            }
            case FORMULA: {
                return "formula";
            }
        }
        return "#unknown cell type (" + cellType + ")#";
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public String getCellFormula() {
        if (!this.formulaType) {
            throw new IllegalStateException("This cell does not have a formula");
        }
        return this.formula;
    }

    public XSSFRichTextString getRichStringCellValue() {
        XSSFRichTextString rt;
        CellType cellType = this.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = this.getCachedFormulaResultType();
        }
        switch (cellType) {
            case BLANK: {
                rt = new XSSFRichTextString("");
                break;
            }
            case STRING: {
                rt = new XSSFRichTextString(this.getStringCellValue());
                break;
            }
            default: {
                throw new NotSupportedException("getRichStringCellValue does not support cell type " + cellType.toString());
            }
        }
        return rt;
    }

    public CellType getCachedFormulaResultType() {
        if (this.formulaType) {
            if (this.contentsSupplier.getContent() == null || this.type == null) {
                return CellType.BLANK;
            }
            if ("n".equals(this.type)) {
                return CellType.NUMERIC;
            }
            if ("d".equals(this.type)) {
                return CellType.NUMERIC;
            }
            if ("s".equals(this.type) || "inlineStr".equals(this.type) || "str".equals(this.type)) {
                return CellType.STRING;
            }
            if ("b".equals(this.type)) {
                return CellType.BOOLEAN;
            }
            if ("e".equals(this.type)) {
                return CellType.ERROR;
            }
            throw new NotSupportedException("Unsupported cell type '" + this.type + "'");
        }
        throw new IllegalStateException("Only formula cells have cached results");
    }

    public LocalDateTime getLocalDateTimeCellValue() {
        if (this.getCellType() == CellType.STRING) {
            throw new IllegalStateException("Cell type cannot be CELL_TYPE_STRING");
        }
        return this.rawContents == null ? null : DateUtil.getLocalDateTime((double)this.getNumericCellValue(), (boolean)this.use1904Dates);
    }

    public byte getErrorCellValue() {
        CellType cellType = this.getCellType();
        if (cellType != CellType.ERROR) {
            throw StreamingCell.typeMismatch(CellType.ERROR, cellType, false);
        }
        String code = this.rawContents;
        if (code == null) {
            return 0;
        }
        try {
            return FormulaError.forString((String)code).getCode();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unexpected error code", e);
        }
    }

    public CellAddress getAddress() {
        return new CellAddress((Cell)this);
    }

    public Comment getCellComment() {
        return this.sheet == null ? null : this.sheet.getCellComment(this.getAddress());
    }

    public Hyperlink getHyperlink() {
        return this.sheet == null ? null : this.sheet.getHyperlink(this.getAddress());
    }

    public void setCellType(CellType cellType) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setBlank() {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setCellValue(double value) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setCellValue(Date value) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setCellValue(Calendar value) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setCellValue(LocalDate value) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setCellValue(LocalDateTime value) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setCellValue(RichTextString value) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setCellValue(String value) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setCellFormula(String formula) throws FormulaParseException {
        throw new NotSupportedException("update operations are not supported");
    }

    public void removeFormula() throws IllegalStateException {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setCellValue(boolean value) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setCellErrorValue(byte value) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setAsActiveCell() {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setCellComment(Comment comment) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void removeCellComment() {
        throw new NotSupportedException("update operations are not supported");
    }

    public void setHyperlink(Hyperlink link) {
        throw new NotSupportedException("update operations are not supported");
    }

    public void removeHyperlink() {
        throw new NotSupportedException("update operations are not supported");
    }

    public CellRangeAddress getArrayFormulaRange() {
        throw new NotSupportedException();
    }

    public boolean isPartOfArrayFormulaGroup() {
        throw new NotSupportedException();
    }
}

