/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.xlsx.impl.ooxml.HyperlinkData;
import java.net.URI;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.util.CellReference;

public class XlsxHyperlink
implements Hyperlink {
    private final HyperlinkType _type;
    private final PackageRelationship _externalRel;
    private final HyperlinkData hyperlinkData;
    private String _location;

    XlsxHyperlink(HyperlinkData hyperlinkData, PackageRelationship hyperlinkRel) {
        this.hyperlinkData = hyperlinkData;
        this._externalRel = hyperlinkRel;
        if (this._externalRel == null) {
            if (hyperlinkData.getLocation() != null) {
                this._type = HyperlinkType.DOCUMENT;
                this._location = hyperlinkData.getLocation();
            } else {
                if (hyperlinkData.getId() != null) {
                    throw new IllegalStateException("The hyperlink for cell " + hyperlinkData.getRef() + " references relation " + hyperlinkData.getId() + ", but that didn't exist!");
                }
                this._type = HyperlinkType.DOCUMENT;
            }
        } else {
            URI target = this._externalRel.getTargetURI();
            this._location = target.toString();
            if (hyperlinkData.getLocation() != null) {
                this._location = this._location + "#" + hyperlinkData.getLocation();
            }
            this._type = this._location.startsWith("http://") || this._location.startsWith("https://") || this._location.startsWith("ftp://") ? HyperlinkType.URL : (this._location.startsWith("mailto:") ? HyperlinkType.EMAIL : HyperlinkType.FILE);
        }
    }

    public HyperlinkType getType() {
        return this._type;
    }

    public String getCellRef() {
        return this.hyperlinkData.getRef();
    }

    public String getAddress() {
        return this._location;
    }

    public String getLabel() {
        return this.hyperlinkData.getDisplay();
    }

    public String getLocation() {
        return this.hyperlinkData.getLocation();
    }

    private CellReference buildCellReference() {
        String ref = this.hyperlinkData.getRef();
        if (ref == null) {
            ref = "A1";
        }
        return new CellReference(ref);
    }

    public int getFirstColumn() {
        return this.buildCellReference().getCol();
    }

    public int getLastColumn() {
        return this.buildCellReference().getCol();
    }

    public int getFirstRow() {
        return this.buildCellReference().getRow();
    }

    public int getLastRow() {
        return this.buildCellReference().getRow();
    }

    public String getTooltip() {
        return this.hyperlinkData.getTooltip();
    }

    public void setAddress(String address) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setLabel(String label) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setFirstColumn(int col) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setLastColumn(int col) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setFirstRow(int row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setLastRow(int row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }
}

