/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl.ooxml;

import com.github.pjfanning.xlsx.StreamingReader;
import com.github.pjfanning.xlsx.impl.ooxml.OoXmlStrictConverter;
import com.github.pjfanning.xlsx.impl.ooxml.TempDataStore;
import com.github.pjfanning.xlsx.impl.ooxml.TempFileDataStore;
import com.github.pjfanning.xlsx.impl.ooxml.TempMemoryDataStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.internal.MemoryPackagePart;
import org.apache.poi.util.TempFile;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFRelation;

public class OoxmlStrictHelper {
    public static ThemesTable getThemesTable(StreamingReader.Builder builder, OPCPackage pkg) throws IOException, XMLStreamException, InvalidFormatException {
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.THEME.getContentType());
        if (parts.isEmpty()) {
            return null;
        }
        PackagePart part = (PackagePart)parts.get(0);
        File tempFile = TempFile.createTempFile((String)"ooxml-strict-themes", (String)".xml");
        try (TempDataStore tempData = OoxmlStrictHelper.createTempDataStore(builder);){
            try (InputStream is = part.getInputStream();
                 OutputStream os = tempData.getOutputStream();
                 OoXmlStrictConverter converter = new OoXmlStrictConverter(is, os);){
                while (converter.convertNextElement()) {
                }
            }
            MemoryPackagePart newPart = new MemoryPackagePart(pkg, part.getPartName(), part.getContentType());
            try (InputStream is = tempData.getInputStream();){
                newPart.load(is);
            }
            var8_9 = new ThemesTable((PackagePart)newPart);
            return var8_9;
        }
    }

    public static StylesTable getStylesTable(StreamingReader.Builder builder, OPCPackage pkg) throws IOException, XMLStreamException, InvalidFormatException {
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (parts.isEmpty()) {
            return null;
        }
        PackagePart part = (PackagePart)parts.get(0);
        try (TempDataStore tempData = OoxmlStrictHelper.createTempDataStore(builder);){
            try (InputStream is = part.getInputStream();
                 OutputStream os = tempData.getOutputStream();
                 OoXmlStrictConverter converter = new OoXmlStrictConverter(is, os);){
                while (converter.convertNextElement()) {
                }
            }
            MemoryPackagePart newPart = new MemoryPackagePart(pkg, part.getPartName(), part.getContentType());
            try (InputStream is = tempData.getInputStream();){
                newPart.load(is);
            }
            var7_8 = new StylesTable((PackagePart)newPart);
            return var7_8;
        }
    }

    public static SharedStringsTable getSharedStringsTable(StreamingReader.Builder builder, OPCPackage pkg) throws IOException, XMLStreamException, InvalidFormatException {
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (parts.isEmpty()) {
            return null;
        }
        PackagePart part = (PackagePart)parts.get(0);
        try (TempDataStore tempData = OoxmlStrictHelper.createTempDataStore(builder);){
            try (InputStream is = part.getInputStream();
                 OutputStream os = tempData.getOutputStream();
                 OoXmlStrictConverter converter = new OoXmlStrictConverter(is, os);){
                while (converter.convertNextElement()) {
                }
            }
            MemoryPackagePart newPart = new MemoryPackagePart(pkg, part.getPartName(), part.getContentType());
            try (InputStream is = tempData.getInputStream();){
                newPart.load(is);
            }
            var7_8 = new SharedStringsTable((PackagePart)newPart);
            return var7_8;
        }
    }

    public static boolean isStrictOoxmlFormat(OPCPackage pkg) {
        PackageRelationshipCollection coreDocRelationships = pkg.getRelationshipsByType("http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument");
        return coreDocRelationships.size() > 0;
    }

    private static TempDataStore createTempDataStore(StreamingReader.Builder builder) {
        if (builder.avoidTempFiles()) {
            return new TempMemoryDataStore();
        }
        return new TempFileDataStore();
    }
}

