/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl.ooxml;

import com.github.pjfanning.xlsx.impl.ooxml.OoXmlStrictConverter;
import com.github.pjfanning.xlsx.impl.ooxml.OoXmlStrictConverterUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;

public class OoXmlStrictConverterInputStream
extends InputStream {
    private final ZipInputStream input;
    private final ByteArrayOutputStreamExposed buffer = new ByteArrayOutputStreamExposed();
    private final ZipOutputStream output;
    private ReadState readState;
    private ZipEntry zipEntry;
    private byte[] nonXmlEntryReadBuffer = new byte[4096];
    private OoXmlStrictConverter xmlConverter;
    private int readIndex = 0;

    public OoXmlStrictConverterInputStream(InputStream ooXmlStrictInput) {
        this.input = new ZipInputStream(ooXmlStrictInput);
        this.output = new ZipOutputStream(this.buffer);
        this.readState = ReadState.BEFORE_ZIP_ENTRY;
    }

    @Override
    public int read() throws IOException {
        while (!this.hasBytesToRead()) {
            if (this.readState == ReadState.END_STATE) {
                return -1;
            }
            this.keepReadingFromInput();
        }
        ++this.readIndex;
        return this.buffer.getBytes()[this.readIndex - 1];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readBytes;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        while (!this.hasBytesToRead()) {
            if (this.readState == ReadState.END_STATE) {
                return -1;
            }
            this.keepReadingFromInput();
        }
        for (readBytes = 0; readBytes < len && this.hasBytesToRead(); ++readBytes) {
            b[off + readBytes] = this.buffer.getBytes()[this.readIndex];
            ++this.readIndex;
        }
        return readBytes;
    }

    private boolean hasBytesToRead() {
        return this.readIndex < this.buffer.size();
    }

    @Override
    public void close() throws IOException {
        if (this.xmlConverter != null) {
            try {
                this.xmlConverter.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
            this.xmlConverter = null;
        }
        this.input.close();
        this.output.close();
        super.close();
    }

    private void keepReadingFromInput() throws IOException {
        switch (this.readState) {
            case BEFORE_ZIP_ENTRY: {
                this.readEntry();
                break;
            }
            case ZIP_ENTRY_START: {
                this.startZipEntry();
                break;
            }
            case IN_NON_XML_ENTRY: {
                this.readNonXmlEntry();
                break;
            }
            case XML_ENTRY_START: {
                this.startXmlEntry();
                break;
            }
            case IN_XML_ENTRY: {
                this.readXmlEntry();
            }
        }
    }

    private void readXmlEntry() {
        try {
            if (!this.xmlConverter.convertNextElement()) {
                this.xmlConverter.close();
                this.xmlConverter = null;
                this.readState = ReadState.BEFORE_ZIP_ENTRY;
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void startXmlEntry() {
        try {
            this.xmlConverter = new OoXmlStrictConverter(OoXmlStrictConverterUtils.disableClose(this.input), OoXmlStrictConverterUtils.disableClose(this.output));
            this.readState = ReadState.IN_XML_ENTRY;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void readNonXmlEntry() throws IOException {
        int readCount = this.input.read(this.nonXmlEntryReadBuffer);
        if (-1 == readCount) {
            this.input.closeEntry();
            this.output.closeEntry();
            this.readState = ReadState.BEFORE_ZIP_ENTRY;
            return;
        }
        if (0 != readCount) {
            this.output.write(this.nonXmlEntryReadBuffer, 0, readCount);
            this.output.flush();
        }
    }

    private void startZipEntry() throws IOException {
        ZipEntry newZipEntry = new ZipEntry(this.zipEntry.getName());
        this.output.putNextEntry(newZipEntry);
        if (OoXmlStrictConverterUtils.isXml(this.zipEntry.getName())) {
            this.readState = ReadState.XML_ENTRY_START;
            return;
        }
        this.readState = ReadState.IN_NON_XML_ENTRY;
    }

    private void readEntry() throws IOException {
        this.zipEntry = this.input.getNextEntry();
        if (this.zipEntry == null) {
            this.readState = ReadState.END_STATE;
            this.output.flush();
            this.output.close();
            return;
        }
        this.readState = ReadState.ZIP_ENTRY_START;
    }

    private static class ByteArrayOutputStreamExposed
    extends ByteArrayOutputStream {
        private ByteArrayOutputStreamExposed() {
        }

        byte[] getBytes() {
            return this.buf;
        }
    }

    private static enum ReadState {
        BEFORE_ZIP_ENTRY,
        ZIP_ENTRY_START,
        END_STATE,
        XML_ENTRY_START,
        IN_NON_XML_ENTRY,
        IN_XML_ENTRY;

    }
}

