/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl.ooxml;

import com.github.pjfanning.xlsx.StreamingReader;
import com.github.pjfanning.xlsx.impl.ooxml.OoXmlStrictConverter;
import com.github.pjfanning.xlsx.impl.ooxml.ResourceWithTrackedCloseable;
import com.github.pjfanning.xlsx.impl.ooxml.TempDataStore;
import com.github.pjfanning.xlsx.impl.ooxml.TempFileDataStore;
import com.github.pjfanning.xlsx.impl.ooxml.TempMemoryDataStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.internal.MemoryPackagePart;
import org.apache.poi.openxml4j.opc.internal.TempFilePackagePart;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFRelation;

public class OoxmlStrictHelper {
    public static ResourceWithTrackedCloseable<ThemesTable> getThemesTable(StreamingReader.Builder builder, OPCPackage pkg) throws IOException, XMLStreamException, InvalidFormatException {
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.THEME.getContentType());
        if (parts.isEmpty()) {
            return null;
        }
        PackagePart part = (PackagePart)parts.get(0);
        try (TempDataStore tempData = OoxmlStrictHelper.createTempDataStore(builder);){
            InputStream is = part.getInputStream();
            Object object = null;
            try (OutputStream os = tempData.getOutputStream();
                 OoXmlStrictConverter converter = new OoXmlStrictConverter(is, os);){
                while (converter.convertNextElement()) {
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            PackagePart newPart = OoxmlStrictHelper.createTempPackagePart(builder, pkg, part);
            try (InputStream is2 = tempData.getInputStream();){
                newPart.load(is2);
            }
            object = new ResourceWithTrackedCloseable<ThemesTable>(new ThemesTable(newPart), () -> newPart.close());
            return object;
        }
    }

    public static ResourceWithTrackedCloseable<StylesTable> getStylesTable(StreamingReader.Builder builder, OPCPackage pkg) throws IOException, XMLStreamException, InvalidFormatException {
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (parts.isEmpty()) {
            return null;
        }
        PackagePart part = (PackagePart)parts.get(0);
        try (TempDataStore tempData = OoxmlStrictHelper.createTempDataStore(builder);){
            InputStream is = part.getInputStream();
            Object object = null;
            try (OutputStream os = tempData.getOutputStream();
                 OoXmlStrictConverter converter = new OoXmlStrictConverter(is, os);){
                while (converter.convertNextElement()) {
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            PackagePart newPart = OoxmlStrictHelper.createTempPackagePart(builder, pkg, part);
            try (InputStream is2 = tempData.getInputStream();){
                newPart.load(is2);
            }
            object = new ResourceWithTrackedCloseable<StylesTable>(new StylesTable(newPart), () -> newPart.close());
            return object;
        }
    }

    public static SharedStringsTable getSharedStringsTable(StreamingReader.Builder builder, OPCPackage pkg) throws IOException, XMLStreamException, InvalidFormatException {
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (parts.isEmpty()) {
            return null;
        }
        PackagePart part = (PackagePart)parts.get(0);
        try (TempDataStore tempData = OoxmlStrictHelper.createTempDataStore(builder);){
            try (InputStream is = part.getInputStream();
                 OutputStream os = tempData.getOutputStream();
                 OoXmlStrictConverter converter = new OoXmlStrictConverter(is, os);){
                while (converter.convertNextElement()) {
                }
            }
            final PackagePart newPart = OoxmlStrictHelper.createTempPackagePart(builder, pkg, part);
            try (InputStream is = tempData.getInputStream();){
                newPart.load(is);
            }
            var7_8 = new SharedStringsTable(newPart){

                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        newPart.close();
                    }
                }
            };
            return var7_8;
        }
    }

    public static ResourceWithTrackedCloseable getCommentsTable(StreamingReader.Builder builder, PackagePart part) throws IOException, XMLStreamException, InvalidFormatException {
        try (TempDataStore tempData = OoxmlStrictHelper.createTempDataStore(builder);){
            InputStream is = part.getInputStream();
            Object object = null;
            try (OutputStream os = tempData.getOutputStream();
                 OoXmlStrictConverter converter = new OoXmlStrictConverter(is, os);){
                while (converter.convertNextElement()) {
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            PackagePart newPart = OoxmlStrictHelper.createTempPackagePart(builder, part.getPackage(), part);
            try (InputStream is2 = tempData.getInputStream();){
                newPart.load(is2);
            }
            object = new ResourceWithTrackedCloseable<CommentsTable>(new CommentsTable(newPart), () -> newPart.close());
            return object;
        }
    }

    private static TempDataStore createTempDataStore(StreamingReader.Builder builder) {
        if (builder.avoidTempFiles()) {
            return new TempMemoryDataStore();
        }
        return new TempFileDataStore();
    }

    private static PackagePart createTempPackagePart(StreamingReader.Builder builder, OPCPackage pkg, PackagePart part) throws IOException, InvalidFormatException {
        if (builder.avoidTempFiles()) {
            return new MemoryPackagePart(pkg, part.getPartName(), part.getContentType());
        }
        return new TempFilePackagePart(pkg, part.getPartName(), part.getContentType());
    }
}

