/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx;

import com.github.pjfanning.xlsx.exceptions.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.poi.ooxml.util.DocumentHelper;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static NamespaceContext transitionalFormatNamespaceContext = new NamespaceContextImpl("ss", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
    private static NamespaceContextImpl strictFormatNamespaceContext = new NamespaceContextImpl("ss", "http://purl.oclc.org/ooxml/spreadsheetml/main");
    public static final String FALSE_AS_STRING = "0";
    public static final String TRUE_AS_STRING = "1";

    private XmlUtils() {
    }

    public static Document readDocument(InputStream inp) throws IOException, SAXException, ParserConfigurationException {
        return DocumentHelper.readDocument((InputStream)inp);
    }

    public static NodeList searchForNodeList(Document document, String xpath) {
        try {
            XPath xp = XPathFactory.newInstance().newXPath();
            xp.setNamespaceContext(transitionalFormatNamespaceContext);
            NodeList nl = (NodeList)xp.compile(xpath).evaluate(document, XPathConstants.NODESET);
            if (nl.getLength() == 0) {
                xp.setNamespaceContext(strictFormatNamespaceContext);
                nl = (NodeList)xp.compile(xpath).evaluate(document, XPathConstants.NODESET);
            }
            return nl;
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
    }

    public static boolean evaluateBoolean(String bool) {
        return bool.equals(TRUE_AS_STRING) || bool.equalsIgnoreCase("true");
    }

    private static class NamespaceContextImpl
    implements NamespaceContext {
        private Map<String, String> urisByPrefix = new HashMap<String, String>();
        private Map<String, Set<String>> prefixesByURI = new HashMap<String, Set<String>>();

        public NamespaceContextImpl() {
            this.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
            this.addNamespace("xmlns", "http://www.w3.org/2000/xmlns/");
        }

        public NamespaceContextImpl(String prefix, String uri) {
            this();
            this.addNamespace(prefix, uri);
        }

        private void addNamespace(String prefix, String namespaceURI) {
            this.urisByPrefix.put(prefix, namespaceURI);
            if (this.prefixesByURI.containsKey(namespaceURI)) {
                this.prefixesByURI.get(namespaceURI).add(prefix);
            } else {
                HashSet<String> set = new HashSet<String>();
                set.add(prefix);
                this.prefixesByURI.put(namespaceURI, set);
            }
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("prefix cannot be null");
            }
            if (this.urisByPrefix.containsKey(prefix)) {
                return this.urisByPrefix.get(prefix);
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return (String)this.getPrefixes(namespaceURI).next();
        }

        public Iterator getPrefixes(String namespaceURI) {
            if (namespaceURI == null) {
                throw new IllegalArgumentException("namespaceURI cannot be null");
            }
            if (this.prefixesByURI.containsKey(namespaceURI)) {
                return this.prefixesByURI.get(namespaceURI).iterator();
            }
            return Collections.emptySet().iterator();
        }
    }
}

