/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx;

import com.github.pjfanning.xlsx.CommentsImplementationType;
import com.github.pjfanning.xlsx.SharedStringsImplementationType;
import com.github.pjfanning.xlsx.impl.StreamingWorkbook;
import com.github.pjfanning.xlsx.impl.StreamingWorkbookReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Workbook;

public class StreamingReader
implements AutoCloseable {
    private final StreamingWorkbookReader workbook;

    public StreamingReader(StreamingWorkbookReader workbook) {
        this.workbook = workbook;
    }

    @Override
    public void close() throws IOException {
        this.workbook.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int rowCacheSize = 10;
        private int bufferSize = 1024;
        private boolean avoidTempFiles = false;
        private SharedStringsImplementationType sharedStringsImplementationType = SharedStringsImplementationType.POI_READ_ONLY;
        private boolean encryptSstTempFile = false;
        private CommentsImplementationType commentsImplementationType = CommentsImplementationType.POI_DEFAULT;
        private boolean encryptCommentsTempFile = false;
        private boolean adjustLegacyComments = false;
        private boolean readComments = false;
        private boolean readCoreProperties = false;
        private boolean readHyperlinks = false;
        private boolean readShapes = false;
        private boolean readStyles = true;
        private boolean readSharedFormulas = false;
        private boolean fullFormatRichText = false;
        private String password;

        public int getRowCacheSize() {
            return this.rowCacheSize;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean avoidTempFiles() {
            return this.avoidTempFiles;
        }

        public SharedStringsImplementationType getSharedStringsImplementationType() {
            return this.sharedStringsImplementationType;
        }

        public CommentsImplementationType getCommentsImplementationType() {
            return this.commentsImplementationType;
        }

        @Deprecated
        public boolean useSstTempFile() {
            return this.getSharedStringsImplementationType() == SharedStringsImplementationType.TEMP_FILE_BACKED;
        }

        @Deprecated
        public boolean useSstReadOnly() {
            return this.getSharedStringsImplementationType() == SharedStringsImplementationType.POI_READ_ONLY;
        }

        public boolean encryptSstTempFile() {
            return this.encryptSstTempFile;
        }

        public boolean adjustLegacyComments() {
            return this.adjustLegacyComments;
        }

        public boolean readComments() {
            return this.readComments;
        }

        @Deprecated
        public boolean useCommentsTempFile() {
            return this.getCommentsImplementationType() == CommentsImplementationType.TEMP_FILE_BACKED;
        }

        public boolean encryptCommentsTempFile() {
            return this.encryptCommentsTempFile;
        }

        public boolean readCoreProperties() {
            return this.readCoreProperties;
        }

        public boolean readHyperlinks() {
            return this.readHyperlinks;
        }

        public boolean readShapes() {
            return this.readShapes;
        }

        public boolean readSharedFormulas() {
            return this.readSharedFormulas;
        }

        public boolean readStyles() {
            return this.readStyles;
        }

        public boolean fullFormatRichText() {
            return this.fullFormatRichText;
        }

        public Builder rowCacheSize(int rowCacheSize) {
            this.rowCacheSize = rowCacheSize;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder setAvoidTempFiles(boolean avoidTempFiles) {
            this.avoidTempFiles = avoidTempFiles;
            return this;
        }

        public Builder setSharedStringsImplementationType(SharedStringsImplementationType sharedStringsImplementationType) {
            if (sharedStringsImplementationType == null) {
                throw new NullPointerException("sharedStringsImplementationType must not be null");
            }
            this.sharedStringsImplementationType = sharedStringsImplementationType;
            return this;
        }

        public Builder setCommentsImplementationType(CommentsImplementationType commentsImplementationType) {
            if (commentsImplementationType == null) {
                throw new NullPointerException("commentsImplementationType must not be null");
            }
            this.commentsImplementationType = commentsImplementationType;
            return this;
        }

        @Deprecated
        public Builder setUseSstTempFile(boolean useSstTempFile) {
            if (useSstTempFile) {
                return this.setSharedStringsImplementationType(SharedStringsImplementationType.TEMP_FILE_BACKED);
            }
            return this.setSharedStringsImplementationType(SharedStringsImplementationType.POI_READ_ONLY);
        }

        @Deprecated
        public Builder setUseSstReadOnly(boolean useSstReadOnly) {
            if (useSstReadOnly) {
                return this.setSharedStringsImplementationType(SharedStringsImplementationType.POI_READ_ONLY);
            }
            return this.setSharedStringsImplementationType(SharedStringsImplementationType.POI_DEFAULT);
        }

        public Builder setEncryptSstTempFile(boolean encryptSstTempFile) {
            this.encryptSstTempFile = encryptSstTempFile;
            return this;
        }

        @Deprecated
        public Builder setUseCommentsTempFile(boolean useCommentsTempFile) {
            if (useCommentsTempFile) {
                return this.setCommentsImplementationType(CommentsImplementationType.TEMP_FILE_BACKED);
            }
            return this.setCommentsImplementationType(CommentsImplementationType.POI_DEFAULT);
        }

        public Builder setEncryptCommentsTempFile(boolean encryptCommentsTempFile) {
            this.encryptCommentsTempFile = encryptCommentsTempFile;
            return this;
        }

        public Builder setReadComments(boolean readComments) {
            this.readComments = readComments;
            return this;
        }

        public Builder setAdjustLegacyComments(boolean adjustLegacyComments) {
            this.adjustLegacyComments = adjustLegacyComments;
            return this;
        }

        public Builder setReadCoreProperties(boolean readCoreProperties) {
            this.readCoreProperties = readCoreProperties;
            return this;
        }

        public Builder setReadHyperlinks(boolean readHyperlinks) {
            this.readHyperlinks = readHyperlinks;
            return this;
        }

        public Builder setReadShapes(boolean readShapes) {
            this.readShapes = readShapes;
            return this;
        }

        public Builder setReadSharedFormulas(boolean readSharedFormulas) {
            this.readSharedFormulas = readSharedFormulas;
            return this;
        }

        public Builder setReadStyles(boolean readStyles) {
            this.readStyles = readStyles;
            return this;
        }

        public Builder setFullFormatRichText(boolean fullFormatRichText) {
            this.fullFormatRichText = fullFormatRichText;
            return this;
        }

        public Workbook open(InputStream is) {
            StreamingWorkbookReader workbook = new StreamingWorkbookReader(this);
            workbook.init(is);
            return new StreamingWorkbook(workbook);
        }

        public Workbook open(File file) {
            StreamingWorkbookReader workbook = new StreamingWorkbookReader(this);
            workbook.init(file);
            return new StreamingWorkbook(workbook);
        }
    }
}

